/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Note;
import automata.State;
import automata.StateRenamer;
import automata.Transition;
import automata.graph.AutomatonGraph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.GEMLayoutAlgorithm;
import automata.turing.TMState;
import automata.turing.TMTransition;
import automata.turing.TuringMachineBuildingBlocks;
import debug.EDebug;
import gui.editor.ArrowDisplayOnlyTool;
import gui.editor.EditBlockPane;
import gui.editor.Tool;
import gui.editor.TransitionCreator;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.tag.CriticalTag;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.CurvedArrow;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ArrowTool
extends Tool {
    private boolean transitionInFlux = false;
    private TransitionCreator creator;
    private State lastClickedState = null;
    private Transition lastClickedTransition = null;
    private Note lastClickedNote = null;
    private Point initialPointState = new Point();
    private Point initialPointClick = new Point();
    protected StateMenu stateMenu = new StateMenu();
    private TransitionMenu transitionMenu = new TransitionMenu();
    private EmptyMenu emptyMenu = new EmptyMenu();
    private Transition selectedTransition = null;

    public ArrowTool(AutomatonPane view, AutomatonDrawer drawer, TransitionCreator creator) {
        super(view, drawer);
        this.creator = creator;
    }

    public ArrowTool(AutomatonPane view, AutomatonDrawer drawer) {
        super(view, drawer);
        this.creator = TransitionCreator.creatorForAutomaton(this.getAutomaton(), this.getView());
    }

    @Override
    public String getToolTip() {
        return "Attribute Editor";
    }

    @Override
    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/arrow.gif");
        return new ImageIcon(url);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Transition trans;
        if (event.getClickCount() == 1 && (trans = this.getDrawer().transitionAtPoint(event.getPoint())) != null) {
            if (trans.isSelected) {
                trans.isSelected = false;
                this.selectedTransition = null;
            } else {
                if (this.selectedTransition != null) {
                    this.selectedTransition.isSelected = false;
                }
                trans.isSelected = true;
                this.selectedTransition = trans;
            }
            return;
        }
        trans = this.getDrawer().transitionAtPoint(event.getPoint());
        if (trans == null) {
            Rectangle bounds = new Rectangle(0, 0, -1, -1);
            this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
            this.getView().repaint();
            return;
        }
        EDebug.print("Beginning to Edit with creator " + this.creator.getClass());
        this.creator.editTransition(trans, event.getPoint());
    }

    protected void showPopup(MouseEvent event) {
        if (event.isPopupTrigger()) {
            Point p = this.getView().transformFromAutomatonToView(event.getPoint());
            if (this.lastClickedState != null && this.shouldShowStatePopup()) {
                this.stateMenu.show(this.lastClickedState, this.getView(), p);
            } else {
                this.emptyMenu.show(this.getView(), p);
            }
        }
        this.lastClickedState = null;
        this.lastClickedTransition = null;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
            ((AutomatonEnvironment)this.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
        } else {
            EDebug.print("I cannot preserve what you ask");
        }
        this.initialPointClick.setLocation(event.getPoint());
        this.lastClickedState = this.getDrawer().stateAtPoint(event.getPoint());
        if (this.lastClickedState == null) {
            this.lastClickedTransition = this.getDrawer().transitionAtPoint(event.getPoint());
        }
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
        if (this.lastClickedState != null) {
            this.initialPointState.setLocation(this.lastClickedState.getPoint());
            if (!this.lastClickedState.isSelected()) {
                Rectangle bounds = new Rectangle(0, 0, -1, -1);
                this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
                this.getView().getDrawer().setSelectionBounds(bounds);
                this.lastClickedState.setSelect(true);
            }
            this.getView().repaint();
        } else if (this.lastClickedTransition != null) {
            this.initialPointClick.setLocation(event.getPoint());
        } else {
            ArrayList<Note> notes = this.getDrawer().getAutomaton().getNotes();
            int k = 0;
            while (k < notes.size()) {
                notes.get(k).setEditable(false);
                notes.get(k).setEnabled(false);
                notes.get(k).setCaretColor(new Color(255, 255, 150));
                ++k;
            }
            Rectangle bounds = new Rectangle(0, 0, -1, -1);
            this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
            this.getView().getDrawer().setSelectionBounds(bounds);
        }
        Transition[] trans = this.getAutomaton().getTransitions();
        int i = 0;
        while (i < trans.length) {
            if (trans[i].isSelected) {
                this.selectedTransition = trans[i];
                return;
            }
            ++i;
        }
        this.selectedTransition = null;
    }

    protected boolean shouldShowStatePopup() {
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p;
        if (this.lastClickedState != null) {
            if (event.isPopupTrigger()) {
                return;
            }
            p = event.getPoint();
            State[] states = this.getView().getDrawer().getAutomaton().getStates();
            int k = 0;
            while (k < states.length) {
                State curState = states[k];
                if (curState.isSelected()) {
                    int x = curState.getPoint().x + p.x - this.initialPointClick.x;
                    int y = curState.getPoint().y + p.y - this.initialPointClick.y;
                    curState.getPoint().setLocation(x, y);
                    curState.setPoint(curState.getPoint());
                }
                ++k;
            }
            this.initialPointClick = p;
            this.getView().repaint();
        } else if (this.lastClickedTransition != null) {
            State t;
            if (event.isPopupTrigger()) {
                return;
            }
            p = event.getPoint();
            int x = p.x - this.initialPointClick.x;
            int y = p.y - this.initialPointClick.y;
            State f = this.lastClickedTransition.getFromState();
            if (f != (t = this.lastClickedTransition.getToState())) {
                double circlex = p.x - f.getPoint().x;
                double circley = p.y - f.getPoint().y;
                Transition[] trans = this.getAutomaton().getTransitionsFromStateToState(f, t);
                int n = 0;
                while (n < trans.length) {
                    CurvedArrow arrow = this.getView().getDrawer().transitionToArrowMap.get(trans[n]);
                    this.getView().getDrawer().arrowToTransitionMap.put(arrow, trans[n]);
                    this.getView().getDrawer().transitionToArrowMap.put(trans[n], arrow);
                    ++n;
                }
            }
            this.initialPointClick.setLocation(p);
            this.getView().repaint();
        } else {
            int nowX = event.getPoint().x;
            int nowY = event.getPoint().y;
            int leftX = this.initialPointClick.x;
            int topY = this.initialPointClick.y;
            if (nowX < this.initialPointClick.x) {
                leftX = nowX;
            }
            if (nowY < this.initialPointClick.y) {
                topY = nowY;
            }
            Rectangle bounds = new Rectangle(leftX, topY, Math.abs(nowX - this.initialPointClick.x), Math.abs(nowY - this.initialPointClick.y));
            if (!this.transitionInFlux) {
                this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
                this.getView().getDrawer().setSelectionBounds(bounds);
            }
            this.getView().repaint();
        }
        if (this.selectedTransition != null) {
            CurvedArrow ca = this.getView().getDrawer().transitionToArrowMap.get(this.selectedTransition);
            Point myClickP = event.getPoint();
            Point2D control = ca.getCurve().getCtrlPt();
            if (this.transitionInFlux || Math.sqrt((control.getX() - (double)myClickP.x) * (control.getX() - (double)myClickP.x) + (control.getY() - (double)myClickP.y) * (control.getY() - (double)myClickP.y)) < 15.0) {
                this.selectedTransition.setControl(myClickP);
                ca.refreshCurve();
                this.transitionInFlux = true;
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.transitionInFlux = false;
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
        State[] states = this.getView().getDrawer().getAutomaton().getStates();
        int count = 0;
        int k = 0;
        while (k < states.length) {
            if (states[k].isSelected()) {
                ++count;
            }
            ++k;
        }
        Rectangle bounds = this.getView().getDrawer().getSelectionBounds();
        if (count == 1 && bounds.isEmpty() && this.lastClickedState != null) {
            this.lastClickedState.setSelect(false);
        }
        bounds = new Rectangle(0, 0, -1, -1);
        this.getView().getDrawer().setSelectionBounds(bounds);
        this.lastClickedState = null;
        this.lastClickedTransition = null;
        this.getView().repaint();
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('a');
    }

    public boolean shouldAllowOnlyFinalStateChange() {
        return false;
    }

    private class EmptyMenu
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private Point myPoint;
        private JCheckBoxMenuItem stateLabels = new JCheckBoxMenuItem("Display State Labels");
        private Note curNote;
        private JMenuItem layoutGraph;
        private JMenuItem addNote;
        private JMenuItem renameStates;
        private JMenuItem adaptView;

        public EmptyMenu() {
            this.stateLabels.addActionListener(this);
            this.add(this.stateLabels);
            this.layoutGraph = new JMenuItem("Layout Graph");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.layoutGraph.addActionListener(this);
                this.add(this.layoutGraph);
            }
            this.renameStates = new JMenuItem("Rename States");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.renameStates.addActionListener(this);
                this.add(this.renameStates);
            }
            this.addNote = new JMenuItem("Add Note");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.addNote.addActionListener(this);
                this.add(this.addNote);
            }
            this.adaptView = new JCheckBoxMenuItem("Auto-Zoom");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.adaptView.addActionListener(this);
                this.add(this.adaptView);
            }
        }

        public void show(Component comp, Point at) {
            this.stateLabels.setSelected(ArrowTool.this.getDrawer().doesDrawStateLabels());
            this.adaptView.setSelected(ArrowTool.this.getView().getAdapt());
            this.myPoint = at;
            this.show(comp, at.x, at.y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            if (item == this.stateLabels) {
                ArrowTool.this.getView().getDrawer().shouldDrawStateLabels(item.isSelected());
            } else if (item == this.layoutGraph) {
                AutomatonGraph g = new AutomatonGraph(ArrowTool.this.getAutomaton());
                GEMLayoutAlgorithm alg = new GEMLayoutAlgorithm();
                ((LayoutAlgorithm)alg).layout(g, null);
                g.moveAutomatonStates();
                ArrowTool.this.getView().fitToBounds(30);
            } else if (item == this.renameStates) {
                ((AutomatonEnvironment)ArrowTool.this.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
                StateRenamer.rename(ArrowTool.this.getAutomaton());
            } else if (item == this.adaptView) {
                ArrowTool.this.getView().setAdapt(item.isSelected());
            } else if (item == this.addNote) {
                ((AutomatonEnvironment)ArrowTool.this.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
                Note newNote = new Note(this.myPoint, "insert_text");
                newNote.initializeForView(ArrowTool.this.getView());
                ArrowTool.this.getView().getDrawer().getAutomaton().addNote(newNote);
            }
            ArrowTool.this.getView().repaint();
            ArrowTool.this.emptyMenu = new EmptyMenu();
        }
    }

    protected class StateMenu
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private State state;
        protected JCheckBoxMenuItem makeFinal = new JCheckBoxMenuItem("Final");
        protected JCheckBoxMenuItem makeInitial;
        private JMenuItem changeLabel;
        private JMenuItem deleteLabel;
        private JMenuItem deleteAllLabels;
        private JMenuItem editBlock;
        private JMenuItem copyBlock;
        private JMenuItem replaceSymbol;
        private JMenuItem setName;

        public StateMenu() {
            this.makeFinal.addActionListener(this);
            this.add(this.makeFinal);
            this.makeInitial = new JCheckBoxMenuItem("Initial");
            this.changeLabel = new JMenuItem("Change Label");
            this.deleteLabel = new JMenuItem("Clear Label");
            this.deleteAllLabels = new JMenuItem("Clear All Labels");
            this.editBlock = new JMenuItem("Edit Block");
            this.copyBlock = new JMenuItem("Duplicate Block");
            this.replaceSymbol = new JMenuItem("Replace Symbol");
            this.setName = new JMenuItem("Set Name");
            if (ArrowTool.this.shouldAllowOnlyFinalStateChange()) {
                return;
            }
            this.makeInitial.addActionListener(this);
            this.changeLabel.addActionListener(this);
            this.deleteLabel.addActionListener(this);
            this.deleteAllLabels.addActionListener(this);
            this.editBlock.addActionListener(this);
            this.setName.addActionListener(this);
            this.copyBlock.addActionListener(this);
            this.replaceSymbol.addActionListener(this);
            this.add(this.makeInitial);
            this.add(this.changeLabel);
            this.add(this.deleteLabel);
            this.add(this.deleteAllLabels);
            this.add(this.setName);
        }

        public void show(State state, Component comp, Point at) {
            this.remove(this.editBlock);
            this.state = state;
            if (ArrowTool.this.getDrawer().getAutomaton() instanceof TuringMachineBuildingBlocks) {
                this.add(this.editBlock);
                this.add(this.copyBlock);
                this.editBlock.setEnabled(true);
                this.copyBlock.setEnabled(true);
                this.add(this.replaceSymbol);
                this.replaceSymbol.setEnabled(true);
            }
            this.makeFinal.setSelected(ArrowTool.this.getAutomaton().isFinalState(state));
            this.makeInitial.setSelected(ArrowTool.this.getAutomaton().getInitialState() == state);
            this.deleteLabel.setEnabled(state.getLabel() != null);
            this.show(comp, at.x, at.y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            if (ArrowTool.this.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
                ((AutomatonEnvironment)ArrowTool.this.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
            }
            if (item == this.makeFinal) {
                if (item.isSelected()) {
                    ArrowTool.this.getAutomaton().addFinalState(this.state);
                } else {
                    ArrowTool.this.getAutomaton().removeFinalState(this.state);
                }
            } else if (item == this.makeInitial) {
                if (!item.isSelected()) {
                    this.state = null;
                }
                ArrowTool.this.getAutomaton().setInitialState(this.state);
            } else if (item == this.changeLabel) {
                String oldlabel = this.state.getLabel();
                oldlabel = oldlabel == null ? "" : oldlabel;
                String label = (String)JOptionPane.showInputDialog(this, "Input a new label, or \nset blank to remove the label", "New Label", 3, null, null, oldlabel);
                if (label == null) {
                    return;
                }
                if (label.equals("")) {
                    label = null;
                }
                this.state.setLabel(label);
            } else if (item == this.deleteLabel) {
                this.state.setLabel(null);
            } else if (item == this.deleteAllLabels) {
                State[] states = ArrowTool.this.getAutomaton().getStates();
                int i = 0;
                while (i < states.length) {
                    states[i].setLabel(null);
                    ++i;
                }
            } else if (item == this.editBlock) {
                TMState parent = (TMState)this.state;
                while (((TuringMachineBuildingBlocks)parent.getAutomaton()).getParent() != null) {
                    parent = ((TuringMachineBuildingBlocks)parent.getAutomaton()).getParent();
                }
                TMState tmState = (TMState)this.state;
                if (tmState.myInternalName == null || tmState.myInternalName.contains("Machine" + tmState.getID())) {
                    JPanel panel = new JPanel(new GridLayout(3, 1));
                    JTextField field = new JTextField();
                    panel.add(new JLabel("Note: If you want to save this block as a seperate file, use 'Save As' while in the 'Edit Block' window"));
                    panel.add(new JLabel("Building Block Name "));
                    panel.add(field);
                    int result = JOptionPane.showOptionDialog((Component)e.getSource(), panel, "Give Building Block a Name", 2, 3, null, null, null);
                    if (result != 0 && result != 0) {
                        return;
                    }
                    String input = field.getText();
                    TMState parent2 = tmState;
                    while (((TuringMachineBuildingBlocks)parent2.getAutomaton()).getParent() != null) {
                        parent2 = ((TuringMachineBuildingBlocks)parent2.getAutomaton()).getParent();
                        if (parent2.myInternalName == null || !parent2.myInternalName.equals(String.valueOf(input) + ".jff")) continue;
                        JOptionPane.showMessageDialog((Component)e.getSource(), "Cannot use the same name as a parent block!", "A Parent Block Already Has This Name", 0);
                        return;
                    }
                    for (State regState : tmState.getAutomaton().states) {
                        TMState stateTM = (TMState)regState;
                        if (!stateTM.getInternalName().equals(String.valueOf(input) + ".jff")) continue;
                        Object[] options = new Object[]{"CANCEL", "YES"};
                        int selectedOption = JOptionPane.showOptionDialog((Component)e.getSource(), "We STRONGLY suggest to NOT use building blocks with the same name. Do you wish to continue anyways?", "Same Name as Another Building Block", -1, 2, null, options, options[0]);
                        System.out.println(selectedOption);
                        if (selectedOption == 1) break;
                        return;
                    }
                    this.state.setName(input);
                    System.out.println(tmState.myInternalName);
                    tmState.setInternalName(String.valueOf(input) + ".jff");
                    System.out.println(tmState.myInternalName);
                }
                EditBlockPane editor = new EditBlockPane(((TMState)this.state).getInnerTM());
                EnvironmentFrame rootFrame = parent.getAutomaton().getEnvironmentFrame();
                editor.setBlock(this.state);
                Environment envir = rootFrame.getEnvironment();
                envir.add((Component)editor, "Edit Block", new CriticalTag(){});
                envir.setActive(editor);
            } else if (item == this.setName) {
                String oldName = this.state.getName();
                oldName = oldName == null ? "" : oldName;
                String name = (String)JOptionPane.showInputDialog(this, "Input a new name, or \nset blank to remove the name", "New Name", 3, null, null, oldName);
                if (name == null) {
                    return;
                }
                if (name.equals("")) {
                    name = null;
                }
                this.state.setName(name);
            } else if (item == this.copyBlock) {
                TMState buffer = ((TuringMachineBuildingBlocks)ArrowTool.this.getAutomaton()).createTMState(new Point(this.state.getPoint().x + 4, this.state.getPoint().y));
                buffer.setInnerTM((TuringMachineBuildingBlocks)((TMState)this.state).getInnerTM().clone());
            } else if (item == this.replaceSymbol) {
                String newString;
                assert (this.state instanceof TMState);
                String replaceWith = null;
                String toReplace = null;
                String old = JOptionPane.showInputDialog(null, (Object)"Find");
                if (old == null) {
                    return;
                }
                if (old instanceof String) {
                    toReplace = old;
                }
                if ((newString = JOptionPane.showInputDialog(null, (Object)"Replace With")) == null) {
                    return;
                }
                if (newString instanceof String) {
                    replaceWith = newString;
                }
                this.replaceCharactersInBlock((TMState)this.state, toReplace, replaceWith);
            }
            ArrowTool.this.getView().repaint();
        }

        private void replaceCharactersInBlock(TMState start, String toReplace, String replaceWith) {
            TuringMachineBuildingBlocks tm = start.getInnerTM();
            int i = 0;
            while (i < tm.getStates().length) {
                this.replaceCharactersInBlock((TMState)tm.getStates()[i], toReplace, replaceWith);
                ++i;
            }
            Transition[] trans = tm.getTransitions();
            int i2 = 0;
            while (i2 < trans.length) {
                TMTransition tmTrans = (TMTransition)trans[i2];
                int k = 0;
                while (k < tmTrans.tapes()) {
                    String read = tmTrans.getRead(k);
                    tmTrans.setRead(k, read.replaceAll(toReplace, replaceWith));
                    String write = tmTrans.getWrite(k);
                    tmTrans.setWrite(k, write.replaceAll(toReplace, replaceWith));
                    ++k;
                }
                ++i2;
            }
        }
    }

    private class TransitionMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        private TransitionMenu() {
        }
    }
}

