/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.fsa.FiniteStateAutomaton;
import gui.SplitPaneFactory;
import gui.TooltipAction;
import gui.deterministic.ConversionController;
import gui.deterministic.StateExpanderTool;
import gui.deterministic.TransitionExpanderTool;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.environment.Environment;
import gui.viewer.AutomatonDraggerPane;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class ConversionPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ConversionController controller;
    EditorPane editor;

    public ConversionPane(FiniteStateAutomaton nfa, Environment environment) {
        super(new BorderLayout());
        FiniteStateAutomaton dfa = new FiniteStateAutomaton();
        this.controller = new ConversionController(nfa, dfa, this);
        AutomatonDraggerPane nfaPane = new AutomatonDraggerPane(nfa);
        JSplitPane split = SplitPaneFactory.createSplit(environment, true, 0.25, nfaPane, this.createEditor(dfa));
        this.add((Component)split, "Center");
        this.addComponentListener(new ComponentAdapter(){
            boolean doneBefore = false;

            @Override
            public void componentShown(ComponentEvent event) {
                ConversionPane.this.controller.performFirstLayout();
                ConversionPane.this.editor.getAutomatonPane().repaint();
            }
        });
    }

    private EditorPane createEditor(FiniteStateAutomaton dfa) {
        SelectionDrawer drawer = new SelectionDrawer(dfa);
        this.editor = new EditorPane(drawer, new ToolBox(){

            @Override
            public List<Tool> tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> tools = new LinkedList<Tool>();
                tools.add(new ArrowNontransitionTool(view, drawer));
                tools.add(new TransitionExpanderTool(view, drawer, ConversionPane.this.controller));
                tools.add(new StateExpanderTool(view, drawer, ConversionPane.this.controller));
                return tools;
            }
        });
        this.addExtras(this.editor.getToolBar());
        return this.editor;
    }

    private void addExtras(JToolBar toolbar) {
        toolbar.addSeparator();
        toolbar.add(new TooltipAction("Complete", "This will finish all expansion."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConversionPane.this.controller.complete();
            }
        });
        toolbar.add(new TooltipAction("Done?", "Are we finished?"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConversionPane.this.controller.done();
            }
        });
    }
}

