/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.FrameFactory;
import gui.viewer.SelectionDrawer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class AddTrapStateController {
    private int currentStep = -1;
    private FiniteStateAutomaton automaton;
    private SelectionDrawer drawer;
    private JLabel mainStep;
    private JLabel detailStep;
    private JFrame frame;
    private int remaining = 0;
    private TreeSet<String> myReadSets;
    private HashMap<Integer, ArrayList<String>> myTransitionsMap;
    private HashMap<Integer, ArrayList<String>> myNeededTransitionMap;
    private HashMap<Integer, State> myStateMap;
    private State myTrapState;
    private static final int CREATE_SINGLE_TRAPSTATE = 0;
    private static final int TRANSITIONS_TO_TRAPSTATE = 1;
    private static final int FINISHED = 200;

    public AddTrapStateController(FiniteStateAutomaton automaton, SelectionDrawer drawer, JLabel mainStep, JLabel detailStep, JFrame frame) {
        this.automaton = automaton;
        this.drawer = drawer;
        this.mainStep = mainStep;
        this.detailStep = detailStep;
        this.frame = frame;
        this.currentStep = 0;
        this.nextStep();
    }

    private void nextStep() {
        switch (this.currentStep) {
            case 0: {
                this.currentStep = 0;
                this.mainStep.setText("Make Single Trap State");
                this.detailStep.setText("Create a new state to make a single trap state.");
                if (this.automaton.getFinalStates().length != 1 || this.automaton.getFinalStates()[0] == this.automaton.getInitialState()) {
                    return;
                }
                return;
            }
            case 1: {
                if (this.myReadSets == null) {
                    this.determineRemainingTransition();
                }
                this.mainStep.setText("Adding Transitions    Readable String : " + this.myReadSets);
                this.detailStep.setText("Put transitions from all states to the trap state.   " + this.remaining + " transitions must be added");
                if (this.drawer.numberSelected() != 0) {
                    return;
                }
                return;
            }
            case 200: {
                this.mainStep.setText("Adding a Trap State and Transitions is Finished!");
                this.detailStep.setText("");
                JOptionPane.showMessageDialog(this.frame, "The DFA is now complete!\nIt will now be placed in a new window.");
                FrameFactory.createFrame((FiniteStateAutomaton)this.automaton.clone());
                return;
            }
        }
    }

    private void determineRemainingTransition() {
        ArrayList<Object> temp;
        this.myTransitionsMap = new HashMap();
        this.myNeededTransitionMap = new HashMap();
        this.myReadSets = new TreeSet();
        this.myStateMap = new HashMap();
        State[] s = this.automaton.getStates();
        int i = 0;
        while (i < s.length) {
            this.myTransitionsMap.put(s[i].getID(), new ArrayList());
            this.myStateMap.put(s[i].getID(), s[i]);
            ++i;
        }
        Transition[] t = this.automaton.getTransitions();
        int i2 = 0;
        while (i2 < t.length) {
            this.myReadSets.add(t[i2].getDescription());
            int id = t[i2].getFromState().getID();
            temp = this.myTransitionsMap.get(id);
            temp.add(t[i2].getDescription());
            this.myTransitionsMap.put(id, temp);
            ++i2;
        }
        for (Integer key : this.myTransitionsMap.keySet()) {
            temp = new ArrayList();
            for (String alpha : this.myReadSets) {
                if (this.myTransitionsMap.get(key).contains(alpha)) continue;
                temp.add(alpha);
                ++this.remaining;
            }
            this.myNeededTransitionMap.put(key, temp);
        }
    }

    public void doAll() {
        switch (this.currentStep) {
            case 0: {
                JOptionPane.showMessageDialog(this.frame, "Just create a state.\nIt's not too difficult.", "Create the State", 0);
                return;
            }
        }
        for (Integer key : this.myNeededTransitionMap.keySet()) {
            ArrayList<String> list = this.myNeededTransitionMap.get(key);
            for (String terminal : list) {
                FSATransition t = new FSATransition(this.myStateMap.get(key), this.myTrapState, terminal);
                this.automaton.addTransition(t);
                this.frame.repaint();
            }
        }
        this.currentStep = 200;
        this.nextStep();
    }

    public State stateCreate(Point point) {
        if (this.currentStep != 0) {
            this.outOfOrder();
            return null;
        }
        this.myTrapState = this.automaton.createState(point);
        this.myTrapState.setLabel("Trap State");
        this.frame.repaint();
        this.currentStep = 1;
        this.nextStep();
        return this.myTrapState;
    }

    public void transitionCreate(State from, State to) {
        if (this.currentStep != 1) {
            this.outOfOrder();
            return;
        }
        if (!to.equals(this.myTrapState)) {
            JOptionPane.showMessageDialog(this.frame, "You have to make transition to the trap state!", "Error", 0);
            return;
        }
        String terminal = JOptionPane.showInputDialog(this.frame, (Object)"Transition on what terminal?");
        if (terminal == null) {
            return;
        }
        if (terminal.length() > 1) {
            JOptionPane.showMessageDialog(this.frame, "Terminal can only be a single letter", "Error", 0);
            return;
        }
        ArrayList<String> list = this.myNeededTransitionMap.get(from.getID());
        if (list.contains(terminal)) {
            FSATransition t = new FSATransition(from, to, terminal);
            this.automaton.addTransition(t);
            this.frame.repaint();
            list.remove(terminal);
            this.myNeededTransitionMap.put(from.getID(), list);
            --this.remaining;
            if (this.remaining == 0) {
                this.currentStep = 200;
                this.nextStep();
                return;
            }
            this.detailStep.setText("Put transitions from all states to the trap state.   " + this.remaining + " transitions must be added");
            return;
        }
        if (!this.myReadSets.contains(terminal)) {
            JOptionPane.showMessageDialog(this.frame, "Terminal " + terminal + " is not part of readable string in DFA", "Incorrect input", 0);
        } else {
            JOptionPane.showMessageDialog(this.frame, "There is already a transition using Terminal " + terminal + " from this state", "Incorrect input", 0);
        }
    }

    protected void outOfOrder() {
        JOptionPane.showMessageDialog(this.frame, "That action is inappropriate for this step!", "Out of Order", 0);
    }
}

