/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import automata.turing.TuringMachineBuildingBlocks;
import grammar.cfg.ContextFreeGrammar;
import grammar.lsystem.LSystem;
import gui.action.AboutAction;
import gui.action.ColorChooserAction;
import gui.action.EmptyStringCharacterAction;
import gui.action.NewHelpAction;
import gui.action.OpenAction;
import gui.action.QuitAction;
import gui.action.RestrictedAction;
import gui.action.SetUndoAmountAction;
import gui.action.TestAction;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.menu.MenuBarCreator;
import gui.pumping.CFPumpingLemmaChooser;
import gui.pumping.RegPumpingLemmaChooser;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import regular.RegularExpression;

public class NewAction
extends RestrictedAction {
    private static final long serialVersionUID = 1L;
    private static NewDialog DIALOG = null;

    public NewAction() {
        super("New...", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, MAIN_MENU_MASK));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        NewAction.showNew();
    }

    public static void closeNew() {
        DIALOG.dispose();
        DIALOG = null;
    }

    public static void showNew() {
        if (DIALOG == null) {
            DIALOG = new NewDialog();
        }
        DIALOG.setVisible(true);
        DIALOG.toFront();
    }

    public static void hideNew() {
        DIALOG.setVisible(false);
    }

    private static void createWindow(Serializable object) {
        DIALOG.setVisible(false);
        FrameFactory.createFrame(object);
    }

    private static class NewDialog
    extends JFrame {
        private static final long serialVersionUID = 1L;

        public NewDialog() {
            super("JFLAP 7.1");
            this.getContentPane().setLayout(new GridLayout(0, 1));
            this.initMenu();
            this.initComponents();
            this.setResizable(false);
            this.pack();
            this.setLocation(50, 50);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    if (Universe.numberOfFrames() > 0) {
                        this.setVisible(false);
                    } else {
                        QuitAction.beginQuit();
                    }
                }
            });
        }

        private void initMenu() {
            JMenuBar menuBar = new JMenuBar();
            JMenu menu = new JMenu("File");
            if (Universe.CHOOSER != null) {
                MenuBarCreator.addItem(menu, new OpenAction());
            }
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkExit(0);
                }
                MenuBarCreator.addItem(menu, new QuitAction());
            }
            catch (SecurityException sm) {
                // empty catch block
            }
            menuBar.add(menu);
            menu = new JMenu("Help");
            MenuBarCreator.addItem(menu, new NewHelpAction());
            MenuBarCreator.addItem(menu, new AboutAction());
            menuBar.add(menu);
            menu = new JMenu("Batch");
            MenuBarCreator.addItem(menu, new TestAction());
            menuBar.add(menu);
            menu = new JMenu("Preferences");
            JMenu tmPrefMenu = new JMenu("Turing Machine Preferences");
            tmPrefMenu.add(Universe.curProfile.getTuringFinalCheckBox());
            tmPrefMenu.add(Universe.curProfile.getAcceptByFinalStateCheckBox());
            tmPrefMenu.add(Universe.curProfile.getAcceptByHaltingCheckBox());
            tmPrefMenu.add(Universe.curProfile.getAllowStayCheckBox());
            MenuBarCreator.addItem(menu, new EmptyStringCharacterAction());
            menu.add(new SetUndoAmountAction());
            menu.add(new ColorChooserAction());
            menu.add(tmPrefMenu);
            menuBar.add(menu);
            this.setJMenuBar(menuBar);
        }

        private void initComponents() {
            JButton button = null;
            button = new JButton("Finite Automaton");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new FiniteStateAutomaton());
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Mealy Machine");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new MealyMachine());
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Moore Machine");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new MooreMachine());
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Pushdown Automaton");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] possibleValues = new Object[]{"Multiple Character Input", "Single Character Input"};
                    Object selectedValue = JOptionPane.showInputDialog(null, "Type of PDA Input", "Input", 1, null, possibleValues, possibleValues[0]);
                    if (selectedValue == possibleValues[0]) {
                        NewAction.createWindow(new PushdownAutomaton());
                    } else if (selectedValue == possibleValues[1]) {
                        NewAction.createWindow(new PushdownAutomaton(true));
                    }
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Turing Machine");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new TuringMachine(1));
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Multi-Tape Turing Machine");
            button.addActionListener(new ActionListener(){
                private Integer[] INTS = null;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Number n;
                    if (this.INTS == null) {
                        this.INTS = new Integer[4];
                        int i = 0;
                        while (i < this.INTS.length) {
                            this.INTS[i] = new Integer(i + 2);
                            ++i;
                        }
                    }
                    if ((n = (Number)JOptionPane.showInputDialog(this.getContentPane(), "How many tapes?", "Multi-tape Machine", 3, null, this.INTS, this.INTS[0])) == null) {
                        return;
                    }
                    NewAction.createWindow(new TuringMachine(n.intValue()));
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Turing Machine With Building Blocks");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new TuringMachineBuildingBlocks(1));
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Grammar");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new ContextFreeGrammar());
                }
            });
            this.getContentPane().add(button);
            button = new JButton("L-System");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new LSystem());
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Regular Expression");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new RegularExpression());
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Regular Pumping Lemma");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new RegPumpingLemmaChooser());
                }
            });
            this.getContentPane().add(button);
            button = new JButton("Context-Free Pumping Lemma");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewAction.createWindow(new CFPumpingLemmaChooser());
                }
            });
            this.getContentPane().add(button);
        }
    }
}

