/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.AutomatonChecker;
import automata.fsa.FiniteStateAutomaton;
import gui.action.FSAAction;
import gui.deterministic.ConversionPane;
import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class NFAToDFAAction
extends FSAAction {
    private static final long serialVersionUID = 1L;
    private FiniteStateAutomaton automaton;
    private Environment environment;

    public NFAToDFAAction(FiniteStateAutomaton automaton, Environment environment) {
        super("Convert to DFA", null);
        this.automaton = automaton;
        this.environment = environment;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(this.environment, "The automaton needs an initial state.", "No Initial State", 0);
            return;
        }
        AutomatonChecker ac = new AutomatonChecker();
        if (!ac.isNFA(this.automaton)) {
            JOptionPane.showMessageDialog(this.environment, "This is not an NFA!", "Not an NFA", 0);
            return;
        }
        ConversionPane convert = new ConversionPane((FiniteStateAutomaton)this.automaton.clone(), this.environment);
        this.environment.add((Component)convert, "NFA to DFA", new CriticalTag(){});
        this.environment.setActive(convert);
    }
}

