/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.JTableExtender;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.action.MultipleSimulateAction;
import gui.action.TestAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Profile;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.GrammarInputPane;
import gui.grammar.parse.CYKParsePane;
import gui.sim.multiple.InputTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class MultipleCYKSimulateAction
extends MultipleSimulateAction {
    private static final long serialVersionUID = 1L;
    private Grammar myOriginalGrammar;
    private Grammar myCNFGrammar;
    private Environment myEnvironment;

    public MultipleCYKSimulateAction(Grammar original, Grammar cnf, Environment environment) {
        super(original, environment);
        this.myOriginalGrammar = original;
        this.myEnvironment = environment;
        this.myCNFGrammar = cnf;
    }

    @Override
    public void performAction(Component source) {
        this.table = this.initializeTable(this.getObject());
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            this.getEnvironment().remove(this.getEnvironment().getActive());
        }
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar bar = new JToolBar();
        panel.add((Component)new JScrollPane(this.table), "Center");
        panel.add((Component)bar, "South");
        panel.add((Component)new TableTextSizeSlider(this.table, 0), "North");
        bar.add(new AbstractAction("Load Inputs"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultipleCYKSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel model = (InputTableModel)MultipleCYKSimulateAction.this.table.getModel();
                JFileChooser ourChooser = new JFileChooser(System.getProperties().getProperty("user.dir"));
                int retval = ourChooser.showOpenDialog(null);
                File f = null;
                if (retval == 0) {
                    f = ourChooser.getSelectedFile();
                    try {
                        Scanner sc = new Scanner(f);
                        int last = model.getRowCount() - 1;
                        while (sc.hasNext()) {
                            String temp = sc.next();
                            model.setValueAt(temp, last, 0);
                            ++last;
                        }
                        sc.close();
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        bar.add(new AbstractAction("Run Inputs"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultipleCYKSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel model = (InputTableModel)MultipleCYKSimulateAction.this.table.getModel();
                if (MultipleCYKSimulateAction.this.getObject() instanceof Grammar) {
                    String[][] inputs = model.getInputs();
                    int uniqueInputs = inputs.length;
                    Grammar currentGram = (Grammar)MultipleCYKSimulateAction.this.getObject();
                    CYKParsePane parsePane = new CYKParsePane((GrammarEnvironment)MultipleCYKSimulateAction.this.getEnvironment(), MultipleCYKSimulateAction.this.myOriginalGrammar, MultipleCYKSimulateAction.this.myCNFGrammar, model);
                    parsePane.inputField.setEditable(false);
                    parsePane.row = -1;
                    parsePane.parseMultiple();
                }
            }
        });
        if (!((InputTableModel)this.table.getModel()).isMultiple) {
            bar.add(new AbstractAction("Clear"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MultipleCYKSimulateAction.this.table.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    InputTableModel model = (InputTableModel)MultipleCYKSimulateAction.this.table.getModel();
                    model.clear();
                }
            });
            String empty = "Lambda";
            if (Universe.curProfile.getEmptyString().equals(Profile.LAMBDA)) {
                empty = "Lambda";
            } else if (Universe.curProfile.getEmptyString().equals(Profile.EPSILON)) {
                empty = "Epsilon";
            }
            bar.add(new AbstractAction("Enter " + empty){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = MultipleCYKSimulateAction.this.table.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    int column = 0;
                    while (column < MultipleCYKSimulateAction.this.table.getColumnCount() - 1) {
                        MultipleCYKSimulateAction.this.table.getModel().setValueAt("", row, column);
                        ++column;
                    }
                }
            });
        }
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            bar.add(new AbstractAction("Edit File"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int k = MultipleCYKSimulateAction.this.getMachineIndexBySelectedRow(MultipleCYKSimulateAction.this.table);
                    if (k >= 0 && k < MultipleCYKSimulateAction.this.getEnvironment().myObjects.size() && MultipleCYKSimulateAction.this.getObject() instanceof Grammar) {
                        Grammar cur = (Grammar)MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(k);
                        GrammarInputPane ep = new GrammarInputPane(cur);
                        ep.setName(cur.getFileName());
                        MultipleCYKSimulateAction.this.getEnvironment().add((Component)ep, "Edit", new CriticalTag(){});
                        MultipleCYKSimulateAction.this.getEnvironment().setActive(ep);
                    }
                }
            });
            bar.add(new AbstractAction("Add input string"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Object result;
                    String[] s;
                    Object input;
                    boolean inputsNeeded = true;
                    boolean turing = false;
                    if (MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(0) instanceof TuringMachine) {
                        turing = true;
                    }
                    if ((input = MultipleCYKSimulateAction.this.initialInput(MultipleCYKSimulateAction.this.getEnvironment().getActive(), "Input")) instanceof String) {
                        s = (String[])input;
                        MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.add((String)s);
                    } else if (input instanceof String[]) {
                        s = (String[])input;
                        int k = 0;
                        while (k < s.length) {
                            MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.add(s[k]);
                            ++k;
                        }
                    } else {
                        return;
                    }
                    if (turing) {
                        Object output = MultipleCYKSimulateAction.this.initialInput(MultipleCYKSimulateAction.this.getEnvironment().getActive(), "Expected Output?");
                        if (output instanceof String) {
                            String s2 = (String)output;
                            MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(s2);
                        } else if (output instanceof String[]) {
                            String[] s3 = (String[])output;
                            int k = 0;
                            while (k < s3.length) {
                                MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(s3[k]);
                                ++k;
                            }
                        } else {
                            MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                            return;
                        }
                    }
                    if ((result = MultipleCYKSimulateAction.this.initialInput(MultipleCYKSimulateAction.this.getEnvironment().getActive(), "Expected Result? (Accept or Reject)")) instanceof String) {
                        String s4 = (String)result;
                        MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(s4);
                    } else if (result instanceof String[]) {
                        String[] s5 = (String[])result;
                        MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(s5[0]);
                    } else {
                        MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.remove(MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        return;
                    }
                    MultipleCYKSimulateAction.this.getEnvironment().remove(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                    MultipleCYKSimulateAction.this.performAction(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                }
            });
            bar.add(new AbstractAction("Add file"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TestAction test = new TestAction();
                    test.chooseFile(MultipleCYKSimulateAction.this.getEnvironment().getActive(), false);
                    MultipleCYKSimulateAction.this.getEnvironment().remove(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                    MultipleCYKSimulateAction.this.performAction(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                }
            });
            bar.add(new AbstractAction("Remove file"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int k = MultipleCYKSimulateAction.this.getMachineIndexBySelectedRow(MultipleCYKSimulateAction.this.table);
                    if (k >= 0 && k < MultipleCYKSimulateAction.this.getEnvironment().myObjects.size()) {
                        MultipleCYKSimulateAction.this.getEnvironment().myObjects.remove(k);
                        int row = MultipleCYKSimulateAction.this.table.getSelectedRow();
                        int objSize = MultipleCYKSimulateAction.this.getEnvironment().myObjects.size();
                        int stringSize = MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size();
                        int beginOffset = row % stringSize;
                        int begin = row - beginOffset;
                        int i = 0;
                        while (i < stringSize) {
                            ((InputTableModel)MultipleCYKSimulateAction.this.table.getModel()).deleteRow(begin);
                            ++i;
                        }
                        MultipleCYKSimulateAction.this.table.changeSelection(0, 0, false, false);
                    }
                }
            });
            bar.add(new AbstractAction("Save Results"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    final JFrame frame = new JFrame("Save Location");
                    JRadioButton defaultLocation = new JRadioButton("Save Results with Original File");
                    defaultLocation.setMnemonic(66);
                    defaultLocation.setActionCommand("Save Results with Original File");
                    defaultLocation.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                        }
                    });
                    final JRadioButton specifyLocation = new JRadioButton("Specify New Location");
                    specifyLocation.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                        }
                    });
                    specifyLocation.setMnemonic(67);
                    specifyLocation.setActionCommand("Specify New Location");
                    defaultLocation.setSelected(true);
                    ButtonGroup group = new ButtonGroup();
                    group.add(defaultLocation);
                    group.add(specifyLocation);
                    JPanel panel = new JPanel();
                    panel.add(defaultLocation);
                    panel.add(specifyLocation);
                    frame.getContentPane().add((Component)panel, "Center");
                    JButton accept = new JButton("Accept");
                    accept.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            frame.setVisible(false);
                            String filepath = "";
                            boolean failedSave = false;
                            if (specifyLocation.isSelected()) {
                                File file = null;
                                boolean badname = false;
                                while (badname || file == null) {
                                    if (badname) continue;
                                    Universe.CHOOSER.setFileFilter(null);
                                    Universe.CHOOSER.setDialogTitle("Choose directory to save files in");
                                    Universe.CHOOSER.setFileSelectionMode(1);
                                    int result = Universe.CHOOSER.showSaveDialog(frame);
                                    if (result != 0) break;
                                    file = Universe.CHOOSER.getSelectedFile();
                                    try {
                                        filepath = file.getCanonicalPath();
                                        int last = filepath.lastIndexOf("\\");
                                        if (last == -1) {
                                            filepath = String.valueOf(filepath) + "/";
                                            continue;
                                        }
                                        filepath = String.valueOf(filepath) + "\\";
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (filepath.equals("")) {
                                failedSave = true;
                            }
                            InputTableModel model = (InputTableModel)(this).MultipleCYKSimulateAction.this.table.getModel();
                            String oldfileName = (String)model.getValueAt(0, 0);
                            String fileName = (String)model.getValueAt(0, 0);
                            boolean turing = false;
                            Object machine = (this).MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(0);
                            String base = filepath;
                            if (machine instanceof Automaton) {
                                if (machine instanceof TuringMachine) {
                                    turing = true;
                                }
                                if (failedSave) {
                                    base = ((Automaton)machine).getFilePath();
                                }
                            } else if (machine instanceof Grammar && failedSave) {
                                base = ((Grammar)machine).getFilePath();
                            }
                            try {
                                FileWriter writer = new FileWriter(String.valueOf(base) + "results" + fileName + ".txt");
                                BufferedWriter bwriter = new BufferedWriter(writer);
                                PrintWriter out = new PrintWriter(bwriter);
                                int r = 0;
                                while (r < model.getRowCount()) {
                                    fileName = (String)model.getValueAt(r, 0);
                                    if (!fileName.equals(oldfileName)) {
                                        oldfileName = fileName;
                                        out.flush();
                                        out.close();
                                        if (fileName.equals("")) break;
                                        int index = MultipleCYKSimulateAction.this.getMachineIndexByName(fileName);
                                        machine = (this).MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(index);
                                        if (machine instanceof Automaton) {
                                            if (!specifyLocation.isSelected() || failedSave) {
                                                base = ((Automaton)machine).getFilePath();
                                            }
                                        } else if (machine instanceof Grammar && (!specifyLocation.isSelected() || failedSave)) {
                                            base = ((Grammar)machine).getFilePath();
                                        }
                                        bwriter = new BufferedWriter(new FileWriter(String.valueOf(base) + "results" + fileName + ".txt"));
                                        out = new PrintWriter(bwriter);
                                    }
                                    boolean input = false;
                                    boolean end = false;
                                    boolean output = false;
                                    int c = 1;
                                    while (c < model.getColumnCount()) {
                                        if (model.getColumnName(c).startsWith("Input") && !input) {
                                            out.write("Input: ");
                                            input = true;
                                        }
                                        if (model.getColumnName(c).startsWith("Output") && !output && turing) {
                                            out.write("Output: ");
                                            output = true;
                                        }
                                        if (model.getColumnName(c).startsWith("Result")) {
                                            end = true;
                                            out.write("Result: ");
                                        }
                                        String value = (String)model.getValueAt(r, c);
                                        out.write(String.valueOf(value) + " ");
                                        try {
                                            if (end) {
                                                bwriter.newLine();
                                            }
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        ++c;
                                    }
                                    ++r;
                                }
                                out.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    frame.getContentPane().add((Component)accept, "South");
                    frame.pack();
                    Point point = new Point(100, 50);
                    frame.setLocation(point);
                    frame.setVisible(true);
                }
            });
        }
        this.myPanel = panel;
        Object finObject = this.getObject();
        if (finObject instanceof Grammar) {
            CYKParsePane bp = new CYKParsePane((GrammarEnvironment)this.getEnvironment(), (Grammar)finObject, this.myCNFGrammar, (InputTableModel)this.table.getModel());
            bp.inputField.setEditable(false);
            if (this.getEnvironment().myTestStrings != null && this.getEnvironment().myTestStrings.size() > 0) {
                bp.inputField.setText(this.getEnvironment().myTestStrings.get(0));
            }
            JSplitPane split = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, bp, panel);
            MultiplePane mp = new MultiplePane(split);
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(mp);
        }
    }

    private int getMachineIndexBySelectedRow(JTable table) {
        InputTableModel model = (InputTableModel)table.getModel();
        int row = table.getSelectedRow();
        if (row < 0) {
            return -1;
        }
        String machineFileName = (String)model.getValueAt(row, 0);
        return this.getMachineIndexByName(machineFileName);
    }

    @Override
    public int getMachineIndexByName(String machineFileName) {
        ArrayList<Object> machines = this.getEnvironment().myObjects;
        if (machines == null) {
            return -1;
        }
        int k = 0;
        while (k < machines.size()) {
            Grammar cur;
            Object current = machines.get(k);
            if (current instanceof Grammar && (cur = (Grammar)current).getFileName().equals(machineFileName)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction((Component)e.getSource());
    }

    @Override
    protected void updateView(String machineFileName, String input, JTableExtender table) {
        ArrayList<Object> machines = this.getEnvironment().myObjects;
        Object current = null;
        current = machines != null ? machines.get(0) : this.getEnvironment().getObject();
        if (current instanceof Grammar && table.getSelectedRow() < table.getRowCount() - 1) {
            int spot = this.getMachineIndexBySelectedRow(table);
            Grammar cur = null;
            cur = spot != -1 ? (Grammar)machines.get(spot) : (Grammar)this.getEnvironment().getObject();
            CYKParsePane bp = new CYKParsePane((GrammarEnvironment)this.getEnvironment(), cur, this.myCNFGrammar, null);
            int column = 1;
            if (spot == -1) {
                column = 0;
            }
            bp.inputField.setText((String)table.getModel().getValueAt(table.getSelectedRow(), column));
            bp.inputField.setEditable(false);
            JSplitPane split = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, bp, this.myPanel);
            MultiplePane mp = new MultiplePane(split);
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            EnvironmentFrame frame = Universe.frameForEnvironment(this.getEnvironment());
            String newTitle = cur.getFileName();
            if (newTitle != "") {
                frame.setTitle(newTitle);
            }
            this.getEnvironment().remove(this.getEnvironment().getActive());
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(mp);
        }
    }

    public class MultiplePane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JSplitPane mySplit;

        public MultiplePane(JSplitPane split) {
            super(new BorderLayout());
            this.mySplit = null;
            this.add((Component)split, "Center");
            this.mySplit = split;
        }
    }
}

