/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.Grammar;
import grammar.parse.Operations;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.parse.LLParseTableDerivationPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class LLParseTableAction
extends GrammarAction {
    private static final long serialVersionUID = 1L;
    private GrammarEnvironment environment;
    private EnvironmentFrame frame;

    public LLParseTableAction(GrammarEnvironment environment) {
        super("Build LL(1) Parse Table", null);
        this.environment = environment;
        this.frame = Universe.frameForEnvironment(environment);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Grammar g = this.environment.getGrammar();
        if (g == null) {
            return;
        }
        if (!Operations.isLL1(g) && JOptionPane.showConfirmDialog(this.frame, "The grammar is not LL(1).\nContinue anyway?", "Grammar not LL(1)", 0) == 1) {
            return;
        }
        LLParseTableDerivationPane ptdp = new LLParseTableDerivationPane(this.environment);
        this.environment.add((Component)ptdp, "Build LL(1) Parse", new CriticalTag(){});
        this.environment.setActive(ptdp);
    }
}

