/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import grammar.UnitProductionRemover;
import grammar.UselessProductionRemover;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.transform.ChomskyPane;
import gui.grammar.transform.LambdaPane;
import gui.grammar.transform.UnitPane;
import gui.grammar.transform.UselessPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JOptionPane;

public class GrammarTransformAction
extends GrammarAction {
    private static final long serialVersionUID = 1L;
    private GrammarEnvironment environment;
    private EnvironmentFrame frame;

    public GrammarTransformAction(GrammarEnvironment environment) {
        super("Transform Grammar", null);
        this.environment = environment;
        this.frame = Universe.frameForEnvironment(environment);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Grammar g = this.environment.getGrammar();
        if (g == null) {
            return;
        }
        GrammarTransformAction.hypothesizeLambda(this.environment, g);
    }

    public static void hypothesizeLambda(GrammarEnvironment env, Grammar g) {
        LambdaProductionRemover remover = new LambdaProductionRemover();
        HashSet<String> lambdaDerivers = remover.getCompleteLambdaSet(g);
        if (lambdaDerivers.contains(g.getStartVariable())) {
            JOptionPane.showMessageDialog(env, "WARNING : The start variable derives lambda.\nNew Grammar will not produce lambda String.", "Start Derives Lambda", 0);
        }
        if (lambdaDerivers.size() > 0) {
            LambdaPane lp = new LambdaPane(env, g);
            env.add((Component)lp, "Lambda Removal", new CriticalTag(){});
            env.setActive(lp);
            return;
        }
        GrammarTransformAction.hypothesizeUnit(env, g);
    }

    public static void hypothesizeUnit(GrammarEnvironment env, Grammar g) {
        UnitProductionRemover remover = new UnitProductionRemover();
        if (remover.getUnitProductions(g).length > 0) {
            UnitPane up = new UnitPane(env, g);
            env.add((Component)up, "Unit Removal", new CriticalTag(){});
            env.setActive(up);
            return;
        }
        GrammarTransformAction.hypothesizeUseless(env, g);
    }

    public static void hypothesizeUseless(GrammarEnvironment env, Grammar g) {
        Production[] p2;
        UselessProductionRemover remover = new UselessProductionRemover();
        Grammar g2 = UselessProductionRemover.getUselessProductionlessGrammar(g);
        Production[] p1 = g.getProductions();
        if (p1.length > (p2 = g2.getProductions()).length) {
            UselessPane up = new UselessPane(env, g);
            env.add((Component)up, "Useless Removal", new CriticalTag(){});
            env.setActive(up);
            return;
        }
        GrammarTransformAction.hypothesizeChomsky(env, g);
    }

    public static void hypothesizeChomsky(GrammarEnvironment env, Grammar g) {
        CNFConverter converter = null;
        try {
            converter = new CNFConverter(g);
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(env, e.getMessage(), "Illegal Grammar", 0);
            return;
        }
        Production[] p = g.getProductions();
        boolean chomsky = true;
        int i = 0;
        while (i < p.length) {
            chomsky &= converter.isChomsky(p[i]);
            ++i;
        }
        if (chomsky) {
            JOptionPane.showMessageDialog(env, "The grammar is already in Chomsky NF.", "Already in CNF", 0);
            return;
        }
        ChomskyPane cp = new ChomskyPane(env, g);
        env.add((Component)cp, "Chomsky Converter", new CriticalTag(){});
        env.setActive(cp);
    }
}

