/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.action.ConvertAutomatonToGrammarAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.FSAConvertController;
import gui.viewer.SelectionDrawer;
import gui.viewer.ZoomPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class ConvertFSAToGrammarAction
extends ConvertAutomatonToGrammarAction {
    private static final long serialVersionUID = 1L;

    public ConvertFSAToGrammarAction(AutomatonEnvironment environment) {
        super(environment);
    }

    @Override
    protected boolean checkAutomaton() {
        if (this.getAutomaton().getStates().length > 26) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.getEnvironment()), "There may be at most 26 states for conversion.", "Number of States Error", 0);
            return false;
        }
        HashSet<Transition> bad = new HashSet<Transition>();
        Transition[] t = this.getAutomaton().getTransitions();
        int i = 0;
        while (i < t.length) {
            if (((FSATransition)t[i]).getLabel().matches(".*[A-Z].*")) {
                bad.add(t[i]);
            }
            ++i;
        }
        if (bad.size() != 0) {
            EnvironmentFrame frame = Universe.frameForEnvironment(this.getEnvironment());
            JPanel messagePanel = new JPanel(new BorderLayout());
            SelectionDrawer drawer = new SelectionDrawer(this.getAutomaton());
            JLabel messageLabel = new JLabel();
            ZoomPane zoom = new ZoomPane(drawer);
            JPanel tempPanel = new JPanel(new BorderLayout());
            tempPanel.setBorder(new BevelBorder(1));
            zoom.setPreferredSize(new Dimension(300, 200));
            tempPanel.add((Component)zoom, "Center");
            messagePanel.add((Component)tempPanel, "Center");
            messagePanel.add((Component)messageLabel, "South");
            drawer.clearSelected();
            Iterator it = bad.iterator();
            while (it.hasNext()) {
                drawer.addSelected((Transition)it.next());
            }
            messageLabel.setText("Capital letters are reserved for grammar variables.");
            JOptionPane.showMessageDialog(frame, messagePanel, "Transitions With Capitals Error", 0);
            return false;
        }
        return true;
    }

    @Override
    protected ConvertController initializeController(ConvertPane pane, SelectionDrawer drawer, Automaton automaton) {
        return new FSAConvertController(pane, drawer, (FiniteStateAutomaton)automaton);
    }

    public static boolean isApplicable(Object object) {
        return object instanceof FiniteStateAutomaton;
    }
}

