/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.State;
import automata.turing.TuringMachine;
import gui.editor.EditBlockPane;
import gui.editor.EditorPane;
import gui.environment.Environment;
import gui.environment.tag.PermanentTag;
import gui.environment.tag.Tag;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CloseButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Environment env;

    public CloseButton(Environment environment) {
        this.setDefaults();
        this.env = environment;
        this.env.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CloseButton.this.checkEnabled();
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean editor = false;
                Automaton inside = null;
                State block = null;
                if (CloseButton.this.env.getActive() instanceof EditBlockPane) {
                    editor = true;
                    EditBlockPane blockEditor = (EditBlockPane)CloseButton.this.env.getActive();
                    inside = blockEditor.getAutomaton();
                    block = blockEditor.getBlock();
                }
                CloseButton.this.env.remove(CloseButton.this.env.getActive());
                if (editor) {
                    EditorPane higherEditor = (EditorPane)CloseButton.this.env.getActive();
                    if (!$assertionsDisabled && !(higherEditor.getAutomaton() instanceof TuringMachine)) {
                        throw new AssertionError();
                    }
                    TuringMachine turingMachine = (TuringMachine)higherEditor.getAutomaton();
                }
            }
        });
        this.checkEnabled();
    }

    public void setDefaults() {
        this.setIcon(new ImageIcon(this.getClass().getResource("/ICON/x.gif")));
        this.setPreferredSize(new Dimension(22, 22));
        this.setToolTipText("Dismiss Tab");
    }

    private void checkEnabled() {
        Tag tag = this.env.getTag(this.env.getActive());
        if (this.env.tabbed.getTabCount() == 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!(tag instanceof PermanentTag));
        }
    }
}

