/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import grammar.UnitProductionRemover;
import grammar.UnrestrictedGrammar;
import grammar.UselessProductionRemover;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.parse.CYKParsePane;
import gui.grammar.transform.LambdaController;
import gui.grammar.transform.LambdaPane;
import gui.grammar.transform.UnitController;
import gui.grammar.transform.UnitPane;
import gui.grammar.transform.UselessController;
import gui.grammar.transform.UselessPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;

public class CYKParseAction
extends GrammarAction {
    private static final long serialVersionUID = 1L;
    protected GrammarEnvironment environment;
    protected EnvironmentFrame frame;
    protected Grammar myGrammar;
    protected boolean myErrorInTransform;
    private ArrayList<Production> myTempCNF;

    public CYKParseAction(GrammarEnvironment environment) {
        super("CYK Parse", null);
        this.environment = environment;
        this.frame = Universe.frameForEnvironment(environment);
    }

    public CYKParseAction(String tag, GrammarEnvironment environment) {
        super(tag, null);
        this.environment = environment;
        this.frame = Universe.frameForEnvironment(environment);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Grammar g;
        this.myGrammar = g = this.environment.getGrammar(UnrestrictedGrammar.class);
        if (g == null) {
            return;
        }
        if (g.getTerminals().length == 0) {
            JOptionPane.showMessageDialog(this.environment, "Error : This grammar does not accept any Strings. ", "Cannot Proceed with CYK", 0);
            this.myErrorInTransform = true;
            return;
        }
        this.hypothesizeLambda(this.environment, g);
        if (!this.myErrorInTransform) {
            CYKParsePane cykPane = new CYKParsePane(this.environment, g, this.myGrammar);
            this.environment.add((Component)cykPane, "CYK Parse", new CriticalTag(){});
            this.environment.setActive(cykPane);
        }
    }

    protected void hypothesizeLambda(GrammarEnvironment env, Grammar g) {
        LambdaProductionRemover remover = new LambdaProductionRemover();
        HashSet<String> lambdaDerivers = remover.getCompleteLambdaSet(g);
        remover.getCompleteLambdaSet(g);
        if (lambdaDerivers.contains(g.getStartVariable())) {
            JOptionPane.showMessageDialog(env, "WARNING : The start variable derives lambda.\nNew Grammar will not produce lambda String.", "Start Derives Lambda", 0);
        }
        if (lambdaDerivers.size() > 0) {
            LambdaPane lp = new LambdaPane(env, g);
            LambdaController controller = new LambdaController(lp, g);
            controller.doAll();
            g = controller.getGrammar();
        }
        this.hypothesizeUnit(env, g);
    }

    protected void hypothesizeUnit(GrammarEnvironment env, Grammar g) {
        UnitProductionRemover remover = new UnitProductionRemover();
        if (remover.getUnitProductions(g).length > 0) {
            UnitPane up = new UnitPane(env, g);
            UnitController controller = new UnitController(up, g);
            controller.doAll();
            g = controller.getGrammar();
        }
        this.hypothesizeUseless(env, g);
    }

    protected void hypothesizeUseless(GrammarEnvironment env, Grammar g) {
        Production[] p2;
        UselessProductionRemover remover = new UselessProductionRemover();
        Grammar g2 = UselessProductionRemover.getUselessProductionlessGrammar(g);
        if (g2.getTerminals().length == 0) {
            JOptionPane.showMessageDialog(env, "Error : This grammar does not accept any Strings. ", "Cannot Proceed with CYK", 0);
            this.myErrorInTransform = true;
            return;
        }
        Production[] p1 = g.getProductions();
        if (p1.length > (p2 = g2.getProductions()).length) {
            UselessPane up = new UselessPane(env, g);
            UselessController controller = new UselessController(up, g);
            controller.doAll();
            g = controller.getGrammar();
        }
        this.hypothesizeChomsky(env, g);
    }

    protected void hypothesizeChomsky(GrammarEnvironment env, Grammar g) {
        CNFConverter converter = null;
        try {
            converter = new CNFConverter(g);
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(env, e.getMessage(), "Illegal Grammar", 0);
            return;
        }
        Production[] p = g.getProductions();
        boolean chomsky = true;
        int i = 0;
        while (i < p.length) {
            chomsky &= converter.isChomsky(p[i]);
            ++i;
        }
        if (!chomsky) {
            ArrayList<Production> resultList = new ArrayList<Production>();
            int i2 = 0;
            while (i2 < p.length) {
                this.myTempCNF = new ArrayList();
                converter = new CNFConverter(g);
                this.convertToCNF(converter, p[i2]);
                resultList.addAll(this.myTempCNF);
                ++i2;
            }
            Production[] pp = new Production[resultList.size()];
            int i3 = 0;
            while (i3 < pp.length) {
                pp[i3] = (Production)resultList.get(i3);
                ++i3;
            }
            pp = CNFConverter.convert(pp);
            String var = g.getStartVariable();
            g = new UnrestrictedGrammar();
            g.addProductions(pp);
            g.setStartVariable(var);
        }
        this.myGrammar = g;
    }

    private void convertToCNF(CNFConverter converter, Production p) {
        if (!converter.isChomsky(p)) {
            Production[] temp = converter.replacements(p);
            int j = 0;
            while (j < temp.length) {
                p = temp[j];
                this.convertToCNF(converter, p);
                ++j;
            }
        } else {
            this.myTempCNF.add(p);
        }
    }
}

