/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonChecker;
import automata.State;
import automata.Transition;
import gui.action.FSAAction;
import gui.deterministic.AddTrapStatePane;
import gui.environment.AutomatonEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class AddTrapStateToDFAAction
extends FSAAction {
    private static final long serialVersionUID = 1L;
    private Automaton automaton;
    private AutomatonEnvironment environment;

    public AddTrapStateToDFAAction(AutomatonEnvironment environment) {
        super("Add Trap State to DFA", null);
        this.environment = environment;
        this.automaton = environment.getAutomaton();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The automaton should have an initial state.");
            return;
        }
        AutomatonChecker ac = new AutomatonChecker();
        if (ac.isNFA(this.automaton)) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "This isn't a DFA!");
            return;
        }
        boolean isComplete = this.checkIfDFAisComplete();
        if (isComplete) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "DFA is complete. No need for the Trap State");
            return;
        }
        AddTrapStatePane trapPane = new AddTrapStatePane(this.environment);
        this.environment.add((Component)trapPane, "Adding Trap State", new CriticalTag(){});
        this.environment.setActive(trapPane);
    }

    private boolean checkIfDFAisComplete() {
        Transition[] t = this.automaton.getTransitions();
        State[] s = this.automaton.getStates();
        TreeSet<String> reads = new TreeSet<String>();
        int i = 0;
        while (i < t.length) {
            reads.add(t[i].getDescription());
            ++i;
        }
        int count = 0;
        int i2 = 0;
        while (i2 < s.length) {
            Transition[] tt = this.automaton.getTransitionsFromState(s[i2]);
            if (tt.length < reads.size()) {
                ++count;
            }
            ++i2;
        }
        return count == 0;
    }
}

