/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextFieldSizeSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    static final int FONT_SIZE_MIN = 1;
    static final int FONT_SIZE_MAX = 600;
    static final int FONT_SIZE_INIT = 300;
    static String TEXTFIELD_SIZE_TITLE = "Input Field Text Size (For optimization, move one of the window size adjustors around this window after resizing the text field)";
    JTextField myField;

    public TextFieldSizeSlider(JTextField field, int orientation, String title) {
        super(orientation, 1, 600, 300);
        if (title.equals("Input Field Text Size")) {
            title = TEXTFIELD_SIZE_TITLE;
        }
        this.addChangeListener(new SliderListener());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        this.myField = field;
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            TextFieldSizeSlider.this.myField.setFont(new Font("Default", 0, source.getValue() / 10));
            TextFieldSizeSlider.this.myField.setSize(TextFieldSizeSlider.this.myField.getWidth(), source.getValue() / 10 + 10);
        }
    }
}

