/*
 * Decompiled with CFR 0.152.
 */
package gui;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import gui.action.SimulateAction;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputBox
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String myInputString;
    private final Component myComponent;
    private String myTitle;
    private AutomatonSimulator mySimulator;
    private SimulateAction myAction;
    private boolean myIsTuringMachine;
    private Automaton myAutomaton;

    public InputBox(SimulateAction simulateAction, Component component, String string) {
        this.myAction = simulateAction;
        this.myComponent = component;
        this.myTitle = string;
        JPanel panel = new JPanel(new GridLayout(3, 2));
        JTextField[] fields = new JTextField[1];
        int i = 0;
        while (i < 1) {
            panel.add(new JLabel(String.valueOf(this.myTitle) + " "));
            fields[i] = new JTextField();
            panel.add(fields[i]);
            ++i;
        }
        JButton jb = new JButton("Open Input File");
        panel.add(jb);
        int result = JOptionPane.showOptionDialog(component, panel, this.myTitle, 2, 3, null, null, null);
        if (result != 0 && result != 0) {
            return;
        }
        String[] input = new String[1];
        int i2 = 0;
        while (i2 < 1) {
            input[i2] = fields[i2].getText();
            ++i2;
        }
        System.out.println(input[0]);
    }

    public String getInputString() {
        return this.myInputString;
    }

    public void exit() {
        System.out.println(this.myInputString);
        if (!this.myIsTuringMachine) {
            Configuration[] configs = this.mySimulator.getInitialConfigurations(this.myInputString);
            this.myAction.handleInteraction(this.myAutomaton, this.mySimulator, configs, this.myInputString);
        }
        this.dispose();
    }

    public void addSimulator(Automaton atm, AutomatonSimulator simulator, boolean isTuring) {
        this.myAutomaton = atm;
        this.mySimulator = simulator;
        this.myIsTuringMachine = isTuring;
    }

    public static void main(String[] args) {
        InputBox ib = new InputBox(null, null, "input");
    }
}

