/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class ImageDisplayComponent
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private Image myImage;
    private Point myOrigin;
    private static final Point ZERO_ORIGIN = new Point(0, 0);

    public ImageDisplayComponent() {
        this((Image)null);
    }

    public ImageDisplayComponent(Image image) {
        this.setImage(image);
    }

    public ImageDisplayComponent(URL url) {
        this.setImage(this.getBaseImage(url));
    }

    public ImageDisplayComponent(String filename) {
        this.setImage(this.getBaseImage(filename));
    }

    public Image getImage() {
        return this.myImage;
    }

    public void setImage(Image image, Point origin) {
        this.myImage = image;
        this.myOrigin = origin;
        this.trackImage(this.getImage());
        this.redefineSize();
    }

    public void setImage(Image image) {
        this.setImage(image, ZERO_ORIGIN);
    }

    private Image getBaseImage(String path) {
        return Toolkit.getDefaultToolkit().getImage(path);
    }

    private Image getBaseImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    private boolean trackImage(Image image) {
        if (image == null) {
            return true;
        }
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private void redefineSize() {
        Dimension d = new Dimension(1, 1);
        if (this.myImage != null) {
            d = new Dimension(this.getImage().getWidth(this), this.getImage().getHeight(this));
        }
        this.setPreferredSize(d);
        this.setBounds(-this.myOrigin.x, -this.myOrigin.y, d.width, d.height);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.myImage == null) {
            return;
        }
        Rectangle r = this.getVisibleRect();
        Rectangle r2 = new Rectangle(this.getPreferredSize());
        int offsetx = r.width > r2.width ? (r.width - r2.width) / 2 : 0;
        int offsety = r.height > r2.height ? (r.height - r2.height) / 2 : 0;
        r = r.intersection(r2);
        g.drawImage(this.myImage, r.x + offsetx, r.y + offsety, r.x + r.width + offsetx, r.y + r.height + offsety, r.x, r.y, r.x + r.width, r.y + r.height, this);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getSize().height;
    }
}

