/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.cfg.ContextFreeGrammar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JOptionPane;

public class Operations {
    private static WeakHashMap<Grammar, Map<String, Set<String>>> CACHED_FIRST = new WeakHashMap();
    private static WeakHashMap<Grammar, Map<String, Set<String>>> CACHED_FOLLOW = new WeakHashMap();
    private static WeakHashMap<Grammar, Map<String, Set<Production>>> CACHED_VPMAP = new WeakHashMap();
    public static final char ITEM_POSITION = '\u00b7';

    private Operations() {
    }

    private static Set<String> setForKey(Map<String, Set<String>> map, Object key) {
        return map.get(key);
    }

    public static Map<String, Set<String>> first(Grammar grammar) {
        if (CACHED_FIRST.containsKey(grammar)) {
            return CACHED_FIRST.get(grammar);
        }
        HashMap<String, Set<String>> first = new HashMap<String, Set<String>>();
        String[] terminals = grammar.getTerminals();
        int i = 0;
        while (i < terminals.length) {
            HashSet<String> termSet = new HashSet<String>();
            termSet.add(terminals[i]);
            first.put(terminals[i], termSet);
            ++i;
        }
        String[] variables = grammar.getVariables();
        int i2 = 0;
        while (i2 < variables.length) {
            first.put(variables[i2], new HashSet());
            ++i2;
        }
        boolean hasChanged = true;
        Production[] productions = grammar.getProductions();
        while (hasChanged) {
            hasChanged = false;
            int i3 = 0;
            while (i3 < productions.length) {
                String variable = productions[i3].getLHS();
                String rhs = productions[i3].getRHS();
                Set<String> firstRhs = Operations.first(first, rhs);
                if (Operations.setForKey(first, variable).addAll(firstRhs)) {
                    hasChanged = true;
                }
                ++i3;
            }
        }
        CACHED_FIRST.put(grammar, Collections.unmodifiableMap(first));
        return Operations.first(grammar);
    }

    public static Set<String> first(Map<String, Set<String>> firstSets, String sequence) {
        HashSet<String> first = new HashSet<String>();
        if (sequence.equals("")) {
            first.add("");
        }
        int j = 0;
        while (j < sequence.length()) {
            Set<String> s = Operations.setForKey(firstSets, sequence.substring(j, j + 1));
            if (!s.contains("")) {
                first.addAll(s);
                break;
            }
            if (j != sequence.length() - 1) {
                s.remove("");
            }
            first.addAll(s);
            if (j != sequence.length() - 1) {
                s.add("");
            }
            ++j;
        }
        return first;
    }

    public static Map<String, Set<String>> follow(Grammar grammar) {
        if (CACHED_FOLLOW.containsKey(grammar)) {
            return CACHED_FOLLOW.get(grammar);
        }
        HashMap<String, Set<String>> follow = new HashMap<String, Set<String>>();
        HashSet<String> initialSet = new HashSet<String>();
        initialSet.add("$");
        follow.put(grammar.getStartVariable(), initialSet);
        String[] variables = grammar.getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!variables[i].equals(grammar.getStartVariable())) {
                follow.put(variables[i], new HashSet());
            }
            ++i;
        }
        Map<String, Set<String>> firstSets = Operations.first(grammar);
        Production[] productions = grammar.getProductions();
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            int i2 = 0;
            while (i2 < productions.length) {
                String variable = productions[i2].getLHS();
                String rhs = productions[i2].getRHS();
                int j = 0;
                while (j < rhs.length()) {
                    String rhsVariable = rhs.substring(j, j + 1);
                    if (grammar.isVariable(rhsVariable)) {
                        Set<String> firstFollowing = Operations.first(firstSets, rhs.substring(j + 1));
                        if (firstFollowing.remove("") && Operations.setForKey(follow, rhsVariable).addAll(Operations.setForKey(follow, variable))) {
                            hasChanged = true;
                        }
                        if (Operations.setForKey(follow, rhsVariable).addAll(firstFollowing)) {
                            hasChanged = true;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        CACHED_FOLLOW.put(grammar, Collections.unmodifiableMap(follow));
        return Operations.follow(grammar);
    }

    public static boolean isLL1(Grammar grammar) {
        Map<String, Set<String>> first = Operations.first(grammar);
        Map<String, Set<String>> follow = Operations.follow(grammar);
        if (follow == null) {
            JOptionPane.showMessageDialog(null, "JFLAP failed to find a follow set.", "Error", 0);
            return false;
        }
        HashMap varToProd = new HashMap();
        Production[] productions = grammar.getProductions();
        int i = 0;
        while (i < productions.length) {
            String variable = productions[i].getLHS();
            if (!varToProd.containsKey(variable)) {
                varToProd.put(variable, new ArrayList());
            }
            ((List)varToProd.get(variable)).add(productions[i]);
            ++i;
        }
        String[] variables = grammar.getVariables();
        int i2 = 0;
        while (i2 < variables.length) {
            Set<String> followVar = follow.get(variables[i2]);
            List varList = (List)varToProd.get(variables[i2]);
            if (varList == null) {
                JOptionPane.showMessageDialog(null, "JFLAP failed to find a variable.  You may have used a variable on the right hand side without providing a derivation for it.", "Error", 0);
                return false;
            }
            productions = varList.toArray(new Production[0]);
            int j = 0;
            while (j < productions.length) {
                String alpha = productions[j].getRHS();
                Set<String> alphaFirst = Operations.first(first, alpha);
                int k = j + 1;
                while (k < productions.length) {
                    String beta = productions[k].getRHS();
                    Set<String> betaFirst = Operations.first(first, beta);
                    if (betaFirst.removeAll(alphaFirst)) {
                        return false;
                    }
                    if (betaFirst.contains("") && alphaFirst.removeAll(followVar)) {
                        return false;
                    }
                    if (alphaFirst.contains("") && betaFirst.removeAll(followVar)) {
                        return false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return true;
    }

    public static Grammar getAugmentedGrammar(Grammar grammar) {
        String start = grammar.getStartVariable();
        ContextFreeGrammar g = new ContextFreeGrammar();
        g.setStartVariable(start);
        Production[] prods = grammar.getProductions();
        Production startProduction = new Production(start, start);
        try {
            g.addProduction(startProduction);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        startProduction.setLHS(String.valueOf(start) + "'");
        int i = 0;
        while (i < prods.length) {
            g.addProduction(prods[i]);
            ++i;
        }
        return g;
    }

    public static Set<Production> closure(Grammar grammar, Set<Production> items) {
        items = new HashSet<Production>(items);
        HashSet<Production> closure = new HashSet<Production>(items);
        Map<String, Set<Production>> vp = Operations.getVariableProductionMap(grammar);
        while (true) {
            HashSet<Production> currentStep = new HashSet<Production>();
            for (Production item : closure) {
                String var;
                Set<Production> ps;
                int p = item.getRHS().indexOf(183);
                if (++p == item.getRHS().length() || (ps = vp.get(var = item.getRHS().substring(p, p + 1))) == null) continue;
                for (Production cp : ps) {
                    currentStep.add(new Production(var, String.valueOf('\u00b7') + cp.getRHS()));
                }
            }
            if (!items.addAll(currentStep)) {
                return items;
            }
            closure = currentStep;
        }
    }

    public static Set<Production> goTo(Grammar grammar, Set<Production> items, String symbol) {
        HashSet<Production> more = new HashSet<Production>();
        for (Production item : items) {
            String var;
            int p = item.getRHS().indexOf(183);
            if (++p == item.getRHS().length() || !(var = item.getRHS().substring(p, p + 1)).equals(symbol)) continue;
            String newRhs = String.valueOf(item.getRHS().substring(0, p - 1)) + item.getRHS().substring(p, p + 1) + '\u00b7' + item.getRHS().substring(p + 1, item.getRHS().length());
            more.add(new Production(item.getLHS(), newRhs));
        }
        return Operations.closure(grammar, more);
    }

    public static Map<String, Set<Production>> getVariableProductionMap(Grammar grammar) {
        if (CACHED_VPMAP.containsKey(grammar)) {
            return Collections.unmodifiableMap(CACHED_VPMAP.get(grammar));
        }
        HashMap vp = new HashMap();
        CACHED_VPMAP.put(grammar, vp);
        Production[] p = grammar.getProductions();
        int i = 0;
        while (i < p.length) {
            if (!vp.containsKey(p[i].getLHS())) {
                vp.put(p[i].getLHS(), new HashSet());
            }
            ((Set)vp.get(p[i].getLHS())).add(p[i]);
            ++i;
        }
        return Operations.getVariableProductionMap(grammar);
    }

    public static Production[] getItems(Production production) {
        StringBuffer sb = new StringBuffer(production.getRHS());
        String rhs = production.getRHS();
        Production[] items = new Production[rhs.length() + 1];
        int i = 0;
        while (i <= rhs.length()) {
            sb.insert(i, '\u00b7');
            items[i] = new Production(production.getLHS(), sb.toString());
            sb.deleteCharAt(i);
            ++i;
        }
        return items;
    }

    public static String[] getCanGoto(Set<Production> items) {
        Iterator<Production> it = items.iterator();
        HashSet<String> symbols = new HashSet<String>();
        while (it.hasNext()) {
            Production item = it.next();
            int position = item.getRHS().indexOf(183) + 1;
            if (position == item.getRHS().length()) continue;
            symbols.add(item.getRHS().substring(position, position + 1));
        }
        return symbols.toArray(new String[0]);
    }
}

