/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.LRParseTable;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public abstract class LRParser {
    public static void parse(String string, Grammar grammar, LRParseTable table) {
        string = String.valueOf(string) + "$";
        int p = 0;
        IntStack stack = new IntStack();
        stack.push(0);
        Production[] productions = grammar.getProductions();
        while (true) {
            String read;
            int state;
            String entry;
            if ((entry = table.getValueAt(state = stack.peekInt(), read = "" + string.charAt(p))).length() == 0) {
                return;
            }
            if (entry.charAt(0) == 's') {
                stack.push(read);
                stack.push(Integer.parseInt(entry.substring(1)));
                ++p;
                continue;
            }
            if (entry.charAt(0) == 'r') {
                int prodNumber = Integer.parseInt(entry.substring(1));
                Production red = productions[prodNumber];
                int i = 0;
                while (i < 2 * red.getRHS().length()) {
                    stack.pop();
                    ++i;
                }
                state = stack.peekInt();
                stack.push(red.getLHS());
                stack.push(Integer.parseInt(table.getValueAt(state, red.getLHS())));
                continue;
            }
            if (entry.charAt(0) == 'a') break;
        }
    }

    public static TreeModel parseTree(String string, Grammar grammar, LRParseTable table) {
        string = String.valueOf(string) + "$";
        int p = 0;
        IntStack stack = new IntStack();
        stack.push(0);
        Production[] productions = grammar.getProductions();
        boolean nodeNum = false;
        while (true) {
            String read;
            int state;
            String entry;
            if ((entry = table.getValueAt(state = stack.peekInt(), read = "" + string.charAt(p))).length() == 0) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                Object[] elements = stack.toArray();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof MutableTreeNode) {
                        node.add((MutableTreeNode)elements[i]);
                    }
                    ++i;
                }
                return new DefaultTreeModel(node);
            }
            if (entry.charAt(0) == 's') {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(read, false);
                stack.push(node);
                stack.push(Integer.parseInt(entry.substring(1)));
                ++p;
                continue;
            }
            if (entry.charAt(0) == 'r') {
                int prodNumber = Integer.parseInt(entry.substring(1));
                Production red = productions[prodNumber];
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(red.getLHS());
                int i = 0;
                while (i < red.getRHS().length()) {
                    stack.pop();
                    MutableTreeNode c = (MutableTreeNode)stack.pop();
                    node.insert(c, 0);
                    ++i;
                }
                state = stack.peekInt();
                stack.push(node);
                stack.push(Integer.parseInt(table.getValueAt(state, red.getLHS())));
                continue;
            }
            if (entry.charAt(0) == 'a') break;
        }
        stack.pop();
        return new DefaultTreeModel((TreeNode)stack.pop());
    }

    private static class IntStack
    extends Stack<Object> {
        private static final long serialVersionUID = 1L;

        private IntStack() {
        }

        @Override
        int push(int item) {
            this.push(new Integer(item));
            return item;
        }

        int popInt() {
            return (Integer)this.pop();
        }

        int peekInt() {
            return (Integer)this.peek();
        }
    }
}

