/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.LLParseTable;
import grammar.parse.Operations;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LLParseTableGenerator {
    private LLParseTableGenerator() {
    }

    public static LLParseTable generate(Grammar grammar) {
        LLParseTable table = new LLParseTable(grammar);
        Map<String, Set<String>> first = Operations.first(grammar);
        Map<String, Set<String>> follow = Operations.follow(grammar);
        Production[] productions = grammar.getProductions();
        int i = 0;
        while (i < productions.length) {
            String alpha = productions[i].getRHS();
            String A = productions[i].getLHS();
            Set<String> firsts = Operations.first(first, alpha);
            for (String a : firsts) {
                if (a.equals("")) continue;
                table.addEntry(A, a, alpha);
            }
            if (firsts.contains("")) {
                Set<String> follows = follow.get(A);
                Iterator<String> it = follows.iterator();
                while (it.hasNext()) {
                    table.addEntry(A, it.next(), alpha);
                }
            }
            ++i;
        }
        return table;
    }
}

