/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import grammar.UnitProductionRemover;
import grammar.UselessProductionRemover;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarInputPane;
import gui.grammar.transform.ChomskyPane;
import gui.grammar.transform.LambdaController;
import gui.grammar.transform.LambdaPane;
import gui.grammar.transform.UnitController;
import gui.grammar.transform.UnitPane;
import gui.grammar.transform.UselessController;
import gui.grammar.transform.UselessPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class CYKTracer {
    private Grammar myOriginalGrammar;
    private ArrayList<Production> myTrace;
    private ArrayList<Production> myAnswer;
    private Production[] myOriginalProductions;
    private HashMap<ArrayList<Production>, Production> myLambdaStepMap;
    private HashMap<ArrayList<Production>, Production> myUnitStepMap;
    private ArrayList<Production> myTempCNF;
    private HashMap<Production, ArrayList<Production>> myCNFMap;

    public CYKTracer(Grammar grammar, ArrayList<Production> trace) {
        this.myOriginalGrammar = grammar;
        this.myTrace = trace;
        this.myAnswer = new ArrayList();
        this.myOriginalProductions = this.myOriginalGrammar.getProductions();
        this.initializeLambdaStepMap();
    }

    private void initializeLambdaStepMap() {
        LambdaProductionRemover remover = new LambdaProductionRemover();
        HashSet<String> lambdaDerivers = remover.getCompleteLambdaSet(this.myOriginalGrammar);
        Grammar g = this.myOriginalGrammar;
        if (lambdaDerivers.size() > 0) {
            ArrayList<Production> temp;
            this.myLambdaStepMap = new HashMap();
            HashMap<String, Production> directLambdaProductions = new HashMap<String, Production>();
            HashMap indirectLambdaProductions = new HashMap();
            GrammarEnvironment env = new GrammarEnvironment(new GrammarInputPane(this.myOriginalGrammar));
            LambdaPane lp = new LambdaPane(env, this.myOriginalGrammar);
            LambdaController controller = new LambdaController(lp, this.myOriginalGrammar);
            controller.doStep();
            for (Production production : (HashSet)controller.getLambdaSet()) {
                directLambdaProductions.put(production.getLHS(), production);
            }
            Production[] p = lp.getGrammar().getProductions();
            for (String key : directLambdaProductions.keySet()) {
                int i = 0;
                while (i < p.length) {
                    if (p[i].getRHS().equals(key)) {
                        temp = new ArrayList<Production>();
                        temp.add(p[i]);
                        temp.add((Production)directLambdaProductions.get(key));
                        indirectLambdaProductions.put(p[i].getLHS(), temp);
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < p.length) {
                Production[] p2 = remover.getProductionsToAddForProduction(p[i], lambdaDerivers);
                int j = 0;
                while (j < p2.length) {
                    temp = new ArrayList();
                    if (!p2[j].equals(p[i])) {
                        temp.add(p[i]);
                        ArrayList<String> variables = this.getDifferentVariable(p[i].getRHS(), p2[j].getRHS());
                        int pp = 0;
                        while (pp < variables.size()) {
                            if (directLambdaProductions.keySet().contains(variables.get(pp))) {
                                temp.add((Production)directLambdaProductions.get(variables.get(pp)));
                            } else if (indirectLambdaProductions.keySet().contains(variables.get(pp))) {
                                temp.addAll((Collection)indirectLambdaProductions.get(variables.get(pp)));
                            } else {
                                this.reportError();
                            }
                            ++pp;
                        }
                        this.myLambdaStepMap.put(temp, p2[j]);
                    }
                    ++j;
                }
                ++i;
            }
            controller.doAll();
            g = controller.getGrammar();
        }
        this.intializeUnitStepMap(g);
    }

    private void intializeUnitStepMap(Grammar g) {
        UnitProductionRemover remover = new UnitProductionRemover();
        if (remover.getUnitProductions(g).length > 0) {
            this.myUnitStepMap = new HashMap();
            GrammarEnvironment env = new GrammarEnvironment(new GrammarInputPane(g));
            UnitPane up = new UnitPane(env, g);
            UnitController controller = new UnitController(up, g);
            controller.doStep();
            Production[] units = remover.getUnitProductions(g);
            HashMap<String, Production> removedUnitProductions = new HashMap<String, Production>();
            int i = 0;
            while (i < units.length) {
                removedUnitProductions.put(units[i].getLHS(), units[i]);
                ++i;
            }
            Grammar unitless = remover.getUnitProductionlessGrammar(controller.getGrammar(), remover.getVariableDependencyGraph(g));
            Production[] temp = unitless.getProductions();
            ArrayList<Production> productionsToAdd = new ArrayList<Production>();
            int i2 = 0;
            while (i2 < temp.length) {
                productionsToAdd.add(temp[i2]);
                ++i2;
            }
            g = controller.getGrammar();
            Production[] p = g.getProductions();
            int i3 = 0;
            while (i3 < p.length) {
                if (productionsToAdd.contains(p[i3])) {
                    productionsToAdd.remove(p[i3]);
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < productionsToAdd.size()) {
                ArrayList<Production> tempToAdd = new ArrayList<Production>();
                String var1 = ((Production)productionsToAdd.get(i3)).getLHS();
                if (removedUnitProductions.get(var1) == null) {
                    this.reportError();
                } else {
                    String tempStr;
                    tempToAdd.add((Production)removedUnitProductions.get(var1));
                    String var2 = ((Production)removedUnitProductions.get(var1)).getRHS();
                    boolean isDone = false;
                    int pp = 0;
                    while (pp < p.length) {
                        if (p[pp].getLHS().equals(var2) && (tempStr = p[pp].getRHS()).equals(((Production)productionsToAdd.get(i3)).getRHS())) {
                            tempToAdd.add(p[pp]);
                            isDone = true;
                            break;
                        }
                        ++pp;
                    }
                    block5: while (!isDone && removedUnitProductions.keySet().contains(var2)) {
                        tempToAdd.add((Production)removedUnitProductions.get(var2));
                        var2 = ((Production)removedUnitProductions.get(var2)).getRHS();
                        pp = 0;
                        while (pp < p.length) {
                            if (p[pp].getLHS().equals(var2) && (tempStr = p[pp].getRHS()).equals(((Production)productionsToAdd.get(i3)).getRHS())) {
                                tempToAdd.add(p[pp]);
                                isDone = true;
                                continue block5;
                            }
                            ++pp;
                        }
                    }
                }
                this.myUnitStepMap.put(tempToAdd, (Production)productionsToAdd.get(i3));
                ++i3;
            }
            controller.doAll();
            g = controller.getGrammar();
        }
        this.removeUseless(g);
    }

    private void removeUseless(Grammar g) {
        Production[] p2;
        UselessProductionRemover remover = new UselessProductionRemover();
        Grammar g2 = UselessProductionRemover.getUselessProductionlessGrammar(g);
        Production[] p1 = g.getProductions();
        if (p1.length > (p2 = g2.getProductions()).length) {
            GrammarEnvironment env = new GrammarEnvironment(new GrammarInputPane(g));
            UselessPane up = new UselessPane(env, g);
            UselessController controller = new UselessController(up, g);
            controller.doAll();
            g = controller.getGrammar();
        }
        this.initializeChomskyMap(g);
    }

    private void initializeChomskyMap(Grammar g) {
        CNFConverter converter = new CNFConverter(g);
        Production[] p = g.getProductions();
        boolean chomsky = true;
        int i = 0;
        while (i < p.length) {
            chomsky &= converter.isChomsky(p[i]);
            ++i;
        }
        if (!chomsky) {
            this.myCNFMap = new HashMap();
            GrammarEnvironment env = new GrammarEnvironment(new GrammarInputPane(g));
            ChomskyPane cp = new ChomskyPane(env, g);
            ArrayList resultList = new ArrayList();
            cp.doAll();
            int i2 = 0;
            while (i2 < p.length) {
                this.myTempCNF = new ArrayList();
                CNFConverter cv = new CNFConverter(g);
                this.convertToCNF(cv, p[i2]);
                this.myCNFMap.put(p[i2], this.myTempCNF);
                resultList.addAll(this.myCNFMap.get(p[i2]));
                ++i2;
            }
            Production[] pp = new Production[resultList.size()];
            HashMap<Production, Production> originalToCNF = new HashMap<Production, Production>();
            int i3 = 0;
            while (i3 < pp.length) {
                pp[i3] = (Production)resultList.get(i3);
                ++i3;
            }
            pp = CNFConverter.convert(pp);
            i3 = 0;
            while (i3 < pp.length) {
                originalToCNF.put((Production)resultList.get(i3), pp[i3]);
                ++i3;
            }
            this.finalizeCNFMap(originalToCNF);
            g = cp.getGrammar();
        }
    }

    private void finalizeCNFMap(HashMap<Production, Production> map) {
        for (Production p : this.myCNFMap.keySet()) {
            ArrayList<Production> temp = new ArrayList<Production>();
            for (Production pp : this.myCNFMap.get(p)) {
                temp.add(map.get(pp));
            }
            this.myCNFMap.put(p, temp);
        }
    }

    private void convertToCNF(CNFConverter converter, Production p) {
        if (!converter.isChomsky(p)) {
            Production[] temp = converter.replacements(p);
            int j = 0;
            while (j < temp.length) {
                p = temp[j];
                this.convertToCNF(converter, p);
                ++j;
            }
        } else {
            this.myTempCNF.add(p);
        }
    }

    private ArrayList<String> getDifferentVariable(String str1, String str2) {
        ArrayList<String> result = new ArrayList<String>();
        char[] char1 = str1.toCharArray();
        char[] char2 = str2.toCharArray();
        int index = 0;
        boolean breakOut = false;
        int i = 0;
        while (i < char1.length) {
            if (index == char2.length) {
                breakOut = true;
                break;
            }
            if (char1[i] != char2[index]) {
                result.add("" + char1[i]);
                --index;
            }
            ++index;
            ++i;
        }
        if (breakOut) {
            i = index;
            while (i < char1.length) {
                result.add("" + char1[i]);
                ++i;
            }
        }
        return result;
    }

    public void traceBack() {
        this.backTrackToCNF();
        this.backTrackToUnit();
        this.backTrackToLambda();
        if (this.myAnswer.size() == 0) {
            this.myAnswer.addAll(this.myTrace);
        }
    }

    private void backTrackToCNF() {
        if (this.myCNFMap == null) {
            this.backTrackToUnit();
            return;
        }
        int[] visited = new int[this.myTrace.size()];
        int i = 0;
        while (i < this.myTrace.size()) {
            if (visited[i] == 0) {
                Production target = this.myTrace.get(i);
                if (this.myCNFMap.keySet().contains(target)) {
                    this.myAnswer.add(target);
                    visited[i] = 1;
                } else {
                    for (Production p : this.myCNFMap.keySet()) {
                        if (!this.myCNFMap.get(p).contains(target)) continue;
                        visited = this.searchForRest(this.myCNFMap.get(p), p, visited);
                    }
                }
            }
            ++i;
        }
    }

    private int[] searchForRest(ArrayList<Production> list, Production p, int[] visited) {
        HashSet<Production> visitedProd = new HashSet<Production>();
        int[] original = visited;
        int count = 0;
        int i = 0;
        while (i < this.myTrace.size()) {
            if (list.contains(this.myTrace.get(i)) && visited[i] == 0 && !visitedProd.contains(this.myTrace.get(i))) {
                visited[i] = 1;
                visitedProd.add(this.myTrace.get(i));
                ++count;
            }
            ++i;
        }
        if (count == list.size()) {
            this.myAnswer.add(p);
            return visited;
        }
        return original;
    }

    private void backTrackToUnit() {
        if (this.myUnitStepMap == null) {
            return;
        }
        int index = 0;
        while (index < this.myAnswer.size()) {
            for (ArrayList<Production> key : this.myUnitStepMap.keySet()) {
                if (!this.myUnitStepMap.get(key).equals(this.myAnswer.get(index))) continue;
                this.myAnswer.remove(index);
                int c = 0;
                for (Production p : key) {
                    this.myAnswer.add(index + c, p);
                    ++c;
                }
                index = index + key.size() - 1;
            }
            ++index;
        }
    }

    private void backTrackToLambda() {
        if (this.myLambdaStepMap == null) {
            return;
        }
        int index = 0;
        while (index < this.myAnswer.size()) {
            for (ArrayList<Production> key : this.myLambdaStepMap.keySet()) {
                if (!this.myLambdaStepMap.get(key).equals(this.myAnswer.get(index))) continue;
                this.myAnswer.remove(index);
                int c = 0;
                for (Production p : key) {
                    this.myAnswer.add(index + c, p);
                    ++c;
                }
                index = index + key.size() - 1;
            }
            ++index;
        }
    }

    public Production[] getAnswer() {
        Production[] answer = new Production[this.myAnswer.size()];
        int i = 0;
        while (i < this.myAnswer.size()) {
            answer[i] = this.myAnswer.get(i);
            ++i;
        }
        return answer;
    }

    private void reportError() {
    }
}

