/*
 * Decompiled with CFR 0.152.
 */
package grammar.lsystem;

import grammar.lsystem.LSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Expander {
    private LSystem lsystem;
    private Random stochiastic;
    private List<List<String>> cachedExpansions = new ArrayList<List<String>>();
    private static final Random RANDOM = new Random();
    private Context[] contexts = null;
    protected static final List<String>[] EMPTY_ARRAY = new List[0];

    public Expander(LSystem lsystem) {
        this(lsystem, RANDOM.nextLong());
    }

    public Expander(LSystem lsystem, long seed) {
        this.stochiastic = new Random(seed);
        this.lsystem = lsystem;
        this.cachedExpansions.add(lsystem.getAxiom());
        this.initializeContexts();
    }

    public List<String> expansionForLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Recursion level " + level + " impossible!");
        }
        if (level < this.cachedExpansions.size()) {
            return this.cachedExpansions.get(level);
        }
        List<String> lastOne = this.cachedExpansions.get(this.cachedExpansions.size() - 1);
        int i = this.cachedExpansions.size();
        while (i <= level) {
            lastOne = this.expand(lastOne);
            this.cachedExpansions.add(lastOne);
            ++i;
        }
        return lastOne;
    }

    private List<String> expand(List<String> symbols) {
        if (this.contexts == null) {
            return this.expandNoContext(symbols);
        }
        return this.expandContext(symbols);
    }

    private List<String> expandNoContext(List<String> symbols) {
        ArrayList<String> ne = new ArrayList<String>();
        int i = 0;
        while (i < symbols.size()) {
            block6: {
                String s = symbols.get(i);
                List<String>[] replacements = this.lsystem.getReplacements(s);
                List<String> replacement = null;
                switch (replacements.length) {
                    case 0: {
                        ne.add(s);
                        break block6;
                    }
                    case 1: {
                        replacement = replacements[0];
                        break;
                    }
                    default: {
                        replacement = replacements[this.stochiastic.nextInt(replacements.length)];
                    }
                }
                Iterator<String> it2 = replacement.iterator();
                while (it2.hasNext()) {
                    ne.add(it2.next());
                }
            }
            ++i;
        }
        return ne;
    }

    private List<String> expandContext(List<String> symbols) {
        ArrayList<String> ne = new ArrayList<String>();
        int i = 0;
        while (i < symbols.size()) {
            block8: {
                String s = symbols.get(i);
                ArrayList<List<String>> replacementsList = new ArrayList<List<String>>();
                int j = 0;
                while (j < this.contexts.length) {
                    List<String>[] l = this.contexts[j].matches(symbols, i);
                    this.contexts[j].matches(symbols, i);
                    int k = 0;
                    while (k < l.length) {
                        replacementsList.add(l[k]);
                        ++k;
                    }
                    ++j;
                }
                List<String>[] replacements = replacementsList.toArray(EMPTY_ARRAY);
                List<String> replacement = null;
                switch (replacements.length) {
                    case 0: {
                        ne.add(s);
                        break block8;
                    }
                    case 1: {
                        replacement = replacements[0];
                        break;
                    }
                    default: {
                        replacement = replacements[this.stochiastic.nextInt(replacements.length)];
                    }
                }
                Iterator<String> it2 = replacement.iterator();
                while (it2.hasNext()) {
                    ne.add(it2.next());
                }
            }
            ++i;
        }
        return ne;
    }

    private final void initializeContexts() {
        Iterator<String> symbolIt = this.lsystem.getSymbolsWithReplacements().iterator();
        HashSet searchLengths = new HashSet();
        Integer one = 1;
        ArrayList<Context> contextsList = new ArrayList<Context>();
        boolean hasContexts = false;
        block7: while (symbolIt.hasNext()) {
            String symbol = symbolIt.next();
            List<String> tokens = LSystem.tokenify(symbol);
            List<String>[] replacements = this.lsystem.getReplacements(symbol);
            int context = 0;
            switch (tokens.size()) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    break;
                }
                default: {
                    try {
                        context = Integer.parseInt(tokens.get(0));
                        tokens.get(context + 1);
                    }
                    catch (NumberFormatException e) {
                        continue block7;
                    }
                    catch (IndexOutOfBoundsException e) {
                        continue block7;
                    }
                    hasContexts = true;
                    tokens = tokens.subList(1, tokens.size());
                }
            }
            contextsList.add(new Context(tokens, context, replacements));
        }
        if (hasContexts) {
            this.contexts = contextsList.toArray(new Context[0]);
        }
    }

    private class Context {
        protected List<String> tokens;
        protected int center;
        protected List<String>[] results;

        public Context(List<String> tokens, int center, List<String>[] results) {
            this.tokens = tokens;
            this.center = center;
            this.results = results;
        }

        public List<String>[] matches(List<String> list, int centerList) {
            centerList -= this.center;
            try {
                List<String> sub = list.subList(centerList, centerList + this.tokens.size());
                if (sub.equals(this.tokens)) {
                    return this.results;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return EMPTY_ARRAY;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append(" : tokens(");
            sb.append(this.tokens);
            sb.append(") at ");
            sb.append(this.center);
            sb.append(" with ");
            sb.append(Arrays.asList(this.results));
            return sb.toString();
        }
    }
}

