/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Production;

public class ProductionChecker {
    public static boolean isLinear(Production production) {
        return ProductionChecker.isRightLinear(production) || ProductionChecker.isLeftLinear(production);
    }

    public static boolean isRightLinear(Production production) {
        return ProductionChecker.isRightLinearProductionWithVariable(production) || ProductionChecker.isLinearProductionWithNoVariable(production);
    }

    public static boolean isLeftLinear(Production production) {
        return ProductionChecker.isLeftLinearProductionWithVariable(production) || ProductionChecker.isLinearProductionWithNoVariable(production);
    }

    public static boolean isLeftLinearProductionWithVariable(Production production) {
        char ch;
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String rhs = production.getRHS();
        String[] variables = production.getVariablesOnRHS();
        return variables.length == 1 && ProductionChecker.isVariable(ch = rhs.charAt(0));
    }

    public static boolean isRightLinearProductionWithVariable(Production production) {
        char ch;
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String rhs = production.getRHS();
        String[] variables = production.getVariablesOnRHS();
        return variables.length == 1 && ProductionChecker.isVariable(ch = rhs.charAt(rhs.length() - 1));
    }

    public static boolean isLinearProductionWithNoVariable(Production production) {
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String rhs = production.getRHS();
        String[] terminals = production.getTerminalsOnRHS();
        return rhs.length() == terminals.length;
    }

    public static boolean isUnitProduction(Production production) {
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String rhs = production.getRHS();
        String[] variablesOnRHS = production.getVariablesOnRHS();
        return rhs.length() == 1 && variablesOnRHS.length == 1;
    }

    public static boolean isLambdaProduction(Production production) {
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String rhs = production.getRHS();
        return rhs.length() == 0;
    }

    public static boolean isRestrictedOnLHS(Production production) {
        String lhs = production.getLHS();
        String[] variablesOnLHS = production.getVariablesOnLHS();
        return lhs.length() == 1 && variablesOnLHS.length == 1;
    }

    public static boolean isVariableInProduction(String variable, Production production) {
        String[] variables = production.getVariables();
        int k = 0;
        while (k < variables.length) {
            if (variables[k].equals(variable)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static boolean isTerminalInProduction(String terminal, Production production) {
        String[] terminals = production.getTerminals();
        int k = 0;
        while (k < terminals.length) {
            if (terminals[k].equals(terminal)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static boolean areTerminalsOnRHS(Production production) {
        String rhs = production.getRHS();
        int k = 0;
        while (k < rhs.length()) {
            char ch = rhs.charAt(k);
            if (ProductionChecker.isTerminal(ch)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static boolean isVariable(char ch) {
        return Character.isUpperCase(ch);
    }

    public static boolean isTerminal(char ch) {
        return !ProductionChecker.isVariable(ch);
    }

    public static boolean isVariableOnRHS(Production production, String variable) {
        String[] variables = production.getVariablesOnRHS();
        int k = 0;
        while (k < variables.length) {
            if (variables[k].equals(variable)) {
                return true;
            }
            ++k;
        }
        return false;
    }
}

