/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.Production;
import grammar.ProductionComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CNFConverter {
    private boolean leftAdded;
    private int numVariables = 0;
    private ProductionComparator productionComparator;
    private ProductionDirectory productionDirectory;
    private Grammar grammar;

    public CNFConverter(Grammar grammar) {
        this.grammar = grammar;
        this.productionComparator = new ProductionComparator(grammar);
        this.productionDirectory = new ProductionDirectory(grammar);
    }

    /*
     * Unable to fully structure code
     */
    public static String[] separateString(String string) {
        list = new LinkedList<String>();
        i = string.length() - 1;
        while (i >= 0) {
            block3: {
                start = i;
                if (string.charAt(i) == ')') ** GOTO lbl9
                list.addFirst(string.substring(i, i + 1));
                break block3;
lbl-1000:
                // 1 sources

                {
                    --i;
lbl9:
                    // 2 sources

                    ** while (i > 0 && string.charAt((int)i) != '(')
                }
lbl10:
                // 1 sources

                if (i > 0) {
                    --i;
                }
                list.addFirst(string.substring(i, start + 1));
            }
            --i;
        }
        return list.toArray(new String[0]);
    }

    private String getLeft(String right) {
        String left = this.productionDirectory.getLeft(right);
        this.leftAdded = false;
        if (left != null) {
            return left;
        }
        this.leftAdded = true;
        left = this.grammar.isTerminal(right) ? "B(" + right + ")" : "D(" + ++this.numVariables + ")";
        Production p = new Production(left, right);
        this.productionDirectory.add(p);
        return left;
    }

    public static Production[] convert(Production[] p) {
        TreeSet<String> vars = new TreeSet<String>();
        char c = 'A';
        while (c <= 'Z') {
            vars.add("" + c);
            c = (char)(c + '\u0001');
        }
        TreeSet<String> unresolved = new TreeSet<String>();
        int i = 0;
        while (i < p.length) {
            String[] tokens = CNFConverter.separateString(p[i].getRHS());
            int j = 0;
            while (j < tokens.length) {
                if (tokens[j].length() == 1) {
                    vars.remove(tokens[j]);
                } else {
                    unresolved.add(tokens[j]);
                }
                ++j;
            }
            vars.remove(p[i].getLHS());
            ++i;
        }
        int needed = unresolved.size() + 26 - vars.size();
        if (unresolved.size() > vars.size()) {
            throw new UnsupportedOperationException("26 variables available, but " + needed + " needed!");
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Iterator it = unresolved.iterator();
        Iterator it2 = vars.iterator();
        while (it.hasNext()) {
            replacements.put((String)it.next(), (String)it2.next());
        }
        Production[] pnew = new Production[p.length];
        int i2 = 0;
        while (i2 < p.length) {
            String[] tokens = CNFConverter.separateString(p[i2].getRHS());
            String rhs = "";
            int j = 0;
            while (j < tokens.length) {
                rhs = tokens[j].length() == 1 ? String.valueOf(rhs) + tokens[j] : String.valueOf(rhs) + (String)replacements.get(tokens[j]);
                ++j;
            }
            String lhs = p[i2].getLHS();
            if (lhs.length() != 1) {
                lhs = (String)replacements.get(lhs);
            }
            pnew[i2] = new Production(lhs, rhs);
            ++i2;
        }
        return pnew;
    }

    public Production[] replacements(Production production) {
        String rhs = production.getRHS();
        String lhs = production.getLHS();
        if (rhs.length() == 1) {
            throw new IllegalArgumentException(production + " is a terminal production!");
        }
        String[] tokens = CNFConverter.separateString(rhs);
        int i = 0;
        while (i < tokens.length) {
            if (this.grammar.isTerminal(tokens[i])) {
                return this.determinalize(production);
            }
            ++i;
        }
        if (tokens.length <= 2) {
            if (tokens.length == 2) {
                throw new IllegalArgumentException(production + " has two variables already!");
            }
            throw new IllegalArgumentException(production + " is in bad form!");
        }
        String remainder = rhs.substring(tokens[0].length());
        String left = this.getLeft(remainder);
        if (this.leftAdded) {
            return new Production[]{new Production(lhs, String.valueOf(tokens[0]) + left), new Production(left, remainder)};
        }
        return new Production[]{new Production(lhs, String.valueOf(tokens[0]) + left)};
    }

    public boolean isChomsky(Production production) {
        String[] tokens = CNFConverter.separateString(production.getRHS());
        switch (tokens.length) {
            case 1: {
                return this.grammar.isTerminal(tokens[0]);
            }
            case 2: {
                return !this.grammar.isTerminal(tokens[0]) && !this.grammar.isTerminal(tokens[1]);
            }
        }
        return false;
    }

    public Production[] determinalize(Production production) {
        String[] tokens = CNFConverter.separateString(production.getRHS());
        ArrayList<Production> list = new ArrayList<Production>();
        String rhs = "";
        int i = 0;
        while (i < tokens.length) {
            if (this.grammar.isTerminal(tokens[i])) {
                String newR = this.getLeft(tokens[i]);
                if (this.leftAdded) {
                    list.add(new Production(newR, tokens[i]));
                }
                rhs = String.valueOf(rhs) + newR;
            } else {
                rhs = String.valueOf(rhs) + tokens[i];
            }
            ++i;
        }
        list.add(0, new Production(production.getLHS(), rhs));
        return list.toArray(new Production[0]);
    }

    private class ProductionDirectory {
        private List<Production> productions = new ArrayList<Production>();
        private Map<String, Set<String>> lhsToRhs = new TreeMap<String, Set<String>>();
        private Map<String, String> rhsToLhs = new HashMap<String, String>();

        public ProductionDirectory(Grammar grammar) {
            Production[] p = grammar.getProductions();
            int i = 0;
            while (i < p.length) {
                String lhs = p[i].getLHS();
                String rhs = p[i].getRHS();
                if (rhs.indexOf(40) != -1) {
                    throw new IllegalArgumentException("Grammar has the ( character, which is reserved.");
                }
                if (rhs.indexOf(41) != -1) {
                    throw new IllegalArgumentException("Grammar has the ) character, which is reserved.");
                }
                this.productions.add(p[i]);
                Set<String> rhses = this.lhsToRhs.get(lhs);
                if (rhses == null) {
                    rhses = new HashSet<String>();
                    this.lhsToRhs.put(lhs, rhses);
                }
                rhses.add(rhs);
                ++i;
            }
            for (Map.Entry<String, Set<String>> entry : this.lhsToRhs.entrySet()) {
                Set<String> rhses = entry.getValue();
                Iterator<String> it2 = rhses.iterator();
                String rhs = it2.next();
                if (it2.hasNext()) continue;
                this.rhsToLhs.put(rhs, entry.getKey());
            }
        }

        public void add(Production production) {
            String lhs = production.getLHS();
            String rhs = production.getRHS();
            if (this.rhsToLhs.containsKey(rhs)) {
                throw new IllegalArgumentException(String.valueOf(rhs) + " already represented by " + this.rhsToLhs.get(rhs));
            }
            Set<String> rhses = this.lhsToRhs.get(lhs);
            if (rhses == null) {
                rhses = new HashSet<String>();
                this.lhsToRhs.put(lhs, rhses);
            }
            rhses.add(rhs);
            this.rhsToLhs.put(rhs, lhs);
        }

        public String[] getRight(String lhs) {
            Set<String> rhses = this.lhsToRhs.get(lhs);
            return rhses.toArray(new String[0]);
        }

        public String getLeft(String rhs) {
            return this.rhsToLhs.get(rhs);
        }
    }
}

