/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import automata.turing.TuringMachineBuildingBlocks;
import file.xml.CFPumpingLemmaTransducer;
import file.xml.FSATransducer;
import file.xml.GrammarTransducer;
import file.xml.LSystemTransducer;
import file.xml.MealyTransducer;
import file.xml.MooreTransducer;
import file.xml.PDATransducer;
import file.xml.RETransducer;
import file.xml.RegPumpingLemmaTransducer;
import file.xml.TMBBTransducer;
import file.xml.TMTransducer;
import file.xml.Transducer;
import grammar.Grammar;
import grammar.lsystem.LSystem;
import gui.action.OpenAction;
import gui.pumping.CFPumpingLemmaChooser;
import gui.pumping.RegPumpingLemmaChooser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import regular.RegularExpression;

public class TransducerFactory {
    private static Map<String, Object> typeToTransducer = new HashMap<String, Object>();
    private static Map<Class<?>, Object> classToTransducer = new HashMap();

    static {
        TransducerFactory.add(null, FiniteStateAutomaton.class, new FSATransducer());
        TransducerFactory.add(null, PushdownAutomaton.class, new PDATransducer());
        TransducerFactory.add(null, TuringMachine.class, new TMTransducer());
        TransducerFactory.add(null, TuringMachineBuildingBlocks.class, new TMBBTransducer());
        TransducerFactory.add(null, Grammar.class, new GrammarTransducer());
        TransducerFactory.add(null, RegularExpression.class, new RETransducer());
        TransducerFactory.add(null, LSystem.class, new LSystemTransducer());
        TransducerFactory.add(null, MealyMachine.class, new MealyTransducer());
        TransducerFactory.add(null, MooreMachine.class, new MooreTransducer());
        TransducerFactory.add(null, RegPumpingLemmaChooser.class, new RegPumpingLemmaTransducer());
        TransducerFactory.add(null, CFPumpingLemmaChooser.class, new CFPumpingLemmaTransducer());
    }

    public static Transducer getTransducer(Document document) {
        Object o;
        Element elem = document.getDocumentElement();
        NodeList typeNodes = elem.getElementsByTagName("type");
        NodeList bbNodes = elem.getElementsByTagName("block");
        NodeList multitapeNodes = elem.getElementsByTagName("tapes");
        if (multitapeNodes.getLength() > 0) {
            return TransducerFactory.instantiate(new TMTransducer());
        }
        if (bbNodes.getLength() > 0) {
            return TransducerFactory.instantiate(new TMBBTransducer());
        }
        if (typeNodes.getLength() == 0) {
            throw new IllegalArgumentException("No <type> tag appears to exist!");
        }
        Node typeElement = typeNodes.item(0);
        NodeList subtypeNodes = typeElement.getChildNodes();
        String type = "";
        int i = 0;
        while (i < subtypeNodes.getLength()) {
            Node node = subtypeNodes.item(i);
            if (node.getNodeType() == 3) {
                type = ((Text)node).getData();
                break;
            }
            ++i;
        }
        if (type.equals("turing")) {
            if (OpenAction.openOrRead) {
                return TransducerFactory.instantiate(new TMBBTransducer());
            }
            Object[] possibleValues = new Object[]{"Standard Turing Machine", "Turing Machine with Building Blocks"};
            Object selectedValue = JOptionPane.showInputDialog(null, "What type of Turing machine do you wish to open this file as?", "Type of Turing machine", 1, null, possibleValues, possibleValues[0]);
            if (selectedValue == possibleValues[0]) {
                return TransducerFactory.instantiate(new TMTransducer());
            }
            if (selectedValue == possibleValues[1]) {
                return TransducerFactory.instantiate(new TMBBTransducer());
            }
        }
        if ((o = typeToTransducer.get(type)) == null) {
            throw new IllegalArgumentException("The type \"" + type + "\" is not recognized.");
        }
        return TransducerFactory.instantiate(o);
    }

    public static Transducer getTransducer(Serializable structure) {
        Class<?> c = structure.getClass();
        while (c != null) {
            Object o = classToTransducer.get(c);
            if (o != null) {
                return TransducerFactory.instantiate(o);
            }
            c = c.getSuperclass();
        }
        throw new IllegalArgumentException("Cannot get transducer for object of " + structure.getClass() + "!");
    }

    private static Transducer instantiate(Object object) {
        if (object instanceof Class) {
            try {
                return (Transducer)object.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Could not instantiate " + object + "!");
            }
        }
        if (object instanceof Transducer) {
            return (Transducer)object;
        }
        throw new IllegalArgumentException("Object " + object + " does not correspond to a transducer!");
    }

    private static void add(String type, Class<?> structureClass, Object transducer) {
        if (type == null) {
            type = ((Transducer)transducer).getType();
        }
        typeToTransducer.put(type, transducer);
        classToTransducer.put(structureClass, transducer);
    }
}

