/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import automata.turing.TuringMachineBuildingBlocks;
import file.DataException;
import file.xml.AutomatonTransducer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TMBBTransducer
extends AutomatonTransducer {
    public static final String TURING_TAPES_NAME = "tapes";
    public static final String TRANSITION_TAPE_NAME = "tape";
    public static final String TRANSITION_READ_NAME = "read";
    public static final String TRANSITION_WRITE_NAME = "write";
    public static final String TRANSITION_MOVE_NAME = "move";
    public static final String IS_BLOCK = "block";

    @Override
    protected Automaton createEmptyAutomaton(Document document) {
        Map<String, String> e2t = TMBBTransducer.elementsToText(document.getDocumentElement());
        String s = e2t.get(TURING_TAPES_NAME);
        if (s == null) {
            s = "1";
        }
        try {
            int tapes = Integer.parseInt(s);
            if (tapes < 1 || tapes > 5) {
                throw new DataException(String.valueOf(tapes) + " invalid # of tapes.  Valid # of tapes 1-5.");
            }
            return new TuringMachineBuildingBlocks(tapes);
        }
        catch (NumberFormatException e) {
            throw new DataException("Error reading " + s + " as number of tapes.");
        }
    }

    @Override
    protected Transition createTransition(State from, State to, Node node, Map<String, String> e2t, boolean isBlock) {
        TuringMachineBuildingBlocks tm = (TuringMachineBuildingBlocks)from.getAutomaton();
        int tapes = tm.tapes();
        Object[] readStrings = new String[tapes];
        Object[] writeStrings = new String[tapes];
        Object[] moveStrings = new String[tapes];
        Arrays.fill(readStrings, "");
        Arrays.fill(writeStrings, "");
        Arrays.fill(moveStrings, "R");
        HashMap<String, Object[]> tag2array = new HashMap<String, Object[]>();
        tag2array.put(TRANSITION_READ_NAME, readStrings);
        tag2array.put(TRANSITION_WRITE_NAME, writeStrings);
        tag2array.put(TRANSITION_MOVE_NAME, moveStrings);
        for (String tag : tag2array.keySet()) {
            String[] array = (String[])tag2array.get(tag);
            NodeList nodes = ((Element)node).getElementsByTagName(tag);
            int i = 0;
            while (i < nodes.getLength()) {
                Element elem = (Element)nodes.item(i);
                String tapeString = elem.getAttribute(TRANSITION_TAPE_NAME);
                if (tapeString.length() == 0) {
                    tapeString = "1";
                }
                int tape = 1;
                try {
                    tape = Integer.parseInt(tapeString);
                    if (tape < 1 || tape > tapes) {
                        throw new DataException("In " + tag + " tag, tape " + tape + " identified but only 1-" + tapes + " are valid.");
                    }
                }
                catch (NumberFormatException e) {
                    throw new DataException("In " + tag + " tag, error reading " + tapeString + " as tape.");
                }
                String contained = TMBBTransducer.containedText(elem);
                if (contained == null) {
                    contained = "";
                }
                array[tape - 1] = contained;
                if (isBlock) {
                    int j = 0;
                    while (j < writeStrings.length) {
                        writeStrings[i] = "~";
                        moveStrings[i] = "S";
                        ++j;
                    }
                }
                ++i;
            }
        }
        try {
            TMTransition t = new TMTransition(from, to, (String[])readStrings, (String[])writeStrings, (String[])moveStrings);
            if (isBlock) {
                t.setBlockTransition(true);
            }
            return t;
        }
        catch (IllegalArgumentException e) {
            throw new DataException(e.getMessage());
        }
    }

    @Override
    protected Element createTransitionElement(Document document, Transition transition) {
        Element te = super.createTransitionElement(document, transition);
        TMTransition t = (TMTransition)transition;
        TuringMachineBuildingBlocks tm = (TuringMachineBuildingBlocks)t.getFromState().getAutomaton();
        HashMap<String, String> attr = new HashMap<String, String>();
        int i = 0;
        while (i < tm.tapes()) {
            if (tm.tapes() > 1) {
                attr.put(TRANSITION_TAPE_NAME, "" + (i + 1));
            }
            String read = t.getRead(i);
            String write = t.getWrite(i);
            if (read.equals("\u25a1")) {
                read = "";
            }
            if (write.equals("\u25a1")) {
                write = "";
            }
            te.appendChild(TMBBTransducer.createElement(document, TRANSITION_READ_NAME, attr, read));
            if (t.isBlockTransition()) {
                te.setAttribute(IS_BLOCK, "true");
                return te;
            }
            te.appendChild(TMBBTransducer.createElement(document, TRANSITION_WRITE_NAME, attr, write));
            te.appendChild(TMBBTransducer.createElement(document, TRANSITION_MOVE_NAME, attr, t.getDirection(i)));
            ++i;
        }
        return te;
    }

    @Override
    public String getType() {
        return "turingbb";
    }

    @Override
    public Document toDOM(Serializable structure) {
        Document dom = super.toDOM(structure);
        TuringMachineBuildingBlocks tm = (TuringMachineBuildingBlocks)structure;
        if (tm.tapes() > 1) {
            Element tapesElement = TMBBTransducer.createElement(dom, TURING_TAPES_NAME, null, "" + tm.tapes());
            NodeList list = dom.getDocumentElement().getChildNodes();
            if (list.getLength() == 1) {
                dom.getDocumentElement().appendChild(tapesElement);
            } else {
                dom.getDocumentElement().insertBefore(tapesElement, list.item(1));
            }
        }
        return dom;
    }
}

