/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Codec;
import file.Decoder;
import file.Encoder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodecRegistry {
    private List<Encoder> encoders = new ArrayList<Encoder>();
    private List<Decoder> decoders = new ArrayList<Decoder>();

    public void add(Codec codec) {
        this.addEncoder(codec);
        this.addDecoder(codec);
    }

    private void addEncoder(Encoder encoder) {
        this.encoders.add(encoder);
    }

    private void addDecoder(Decoder decoder) {
        this.decoders.add(decoder);
    }

    public List<Encoder> getEncoders(Serializable structure) {
        if (structure == null) {
            return Collections.unmodifiableList(this.encoders);
        }
        ArrayList<Codec> validEncoders = new ArrayList<Codec>();
        for (Codec codec : this.encoders) {
            if (!codec.canEncode(structure)) continue;
            validEncoders.add(codec);
        }
        return Collections.unmodifiableList(validEncoders);
    }

    public List<Decoder> getDecoders() {
        return Collections.unmodifiableList(this.decoders);
    }
}

