/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import grammar.Production;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TuringToGrammarConverter {
    private static final String SQUARE_SYMBOL = "\u25a1";
    private static final String SQUARE = "=";
    private static final String VAR_START = "V(";
    private static final String VAR_END = ")";
    private HashSet<String> myAllReadableString = new HashSet();
    private HashSet<String> myAllWritableString = new HashSet();

    public Production[] createProductionsForInit(State state, Transition[] tm) {
        int id = state.getID();
        ArrayList<Production> init = new ArrayList<Production>();
        init.add(new Production("S", "V(==)S"));
        init.add(new Production("S", "SV(==)"));
        init.add(new Production("S", "T"));
        this.myAllReadableString.add(SQUARE);
        int i = 0;
        while (i < tm.length) {
            TMTransition trans = (TMTransition)tm[i];
            int tape = trans.getTapeLength();
            int j = 0;
            while (j < tape) {
                String write;
                String str = trans.getRead(j);
                if (str.equals(SQUARE_SYMBOL)) {
                    str = SQUARE;
                }
                if ((write = trans.getWrite(j)).equals(SQUARE_SYMBOL)) {
                    write = SQUARE;
                }
                this.myAllWritableString.add(write);
                if (!this.myAllReadableString.contains(str)) {
                    this.myAllReadableString.add(str);
                    String var1 = VAR_START + str + str + VAR_END;
                    String var2 = VAR_START + str + id + str + VAR_END;
                    init.add(new Production("T", "T" + var1));
                    init.add(new Production("T", var2));
                }
                ++j;
            }
            ++i;
        }
        init.add(new Production(SQUARE, null));
        Production[] answer = new Production[init.size()];
        int i2 = 0;
        while (i2 < answer.length) {
            answer[i2] = (Production)init.get(i2);
            ++i2;
        }
        return answer;
    }

    public Production[] createProductionsForTransition(Transition transition, State[] states) {
        ArrayList<Production> list = new ArrayList<Production>();
        TMTransition trans = (TMTransition)transition;
        HashMap<Integer, Boolean> finalStateMap = new HashMap<Integer, Boolean>();
        int i = 0;
        while (i < states.length) {
            finalStateMap.put(states[i].getID(), true);
            ++i;
        }
        int fromState = trans.getFromState().getID();
        int toState = trans.getToState().getID();
        int tape = trans.getTapeLength();
        int i2 = 0;
        while (i2 < tape) {
            String direction = trans.getDirection(i2);
            String read = trans.getRead(i2);
            String write = trans.getWrite(i2);
            if (read.equals(SQUARE_SYMBOL)) {
                read = SQUARE;
            }
            if (write.equals(SQUARE_SYMBOL)) {
                write = SQUARE;
            }
            for (String p : this.myAllReadableString) {
                for (String a : this.myAllReadableString) {
                    for (String q : this.myAllWritableString) {
                        String lhs3;
                        String lhs2;
                        String rhs;
                        String lhs;
                        Production prod;
                        String rhs_var2;
                        String rhs_var1;
                        String lhs_var2;
                        String lhs_var1;
                        if (direction.equals("R")) {
                            lhs_var1 = VAR_START + a + fromState + read + VAR_END;
                            lhs_var2 = VAR_START + p + q + VAR_END;
                            rhs_var1 = VAR_START + a + write + VAR_END;
                            rhs_var2 = VAR_START + p + toState + q + VAR_END;
                            prod = new Production(String.valueOf(lhs_var1) + lhs_var2, String.valueOf(rhs_var1) + rhs_var2);
                            list.add(prod);
                            if (finalStateMap.containsKey(toState)) {
                                lhs = VAR_START + p + toState + q + VAR_END;
                                rhs = p;
                                list.add(new Production(lhs, rhs));
                                lhs2 = VAR_START + a + q + VAR_END + p;
                                list.add(new Production(lhs2, String.valueOf(a) + rhs));
                                lhs3 = String.valueOf(p) + VAR_START + a + q + VAR_END;
                                list.add(new Production(lhs3, String.valueOf(p) + a));
                            }
                        }
                        if (direction.equals("L")) {
                            lhs_var1 = VAR_START + p + q + VAR_END;
                            lhs_var2 = VAR_START + a + fromState + read + VAR_END;
                            rhs_var1 = VAR_START + p + toState + q + VAR_END;
                            rhs_var2 = VAR_START + a + write + VAR_END;
                            prod = new Production(String.valueOf(lhs_var1) + lhs_var2, String.valueOf(rhs_var1) + rhs_var2);
                            list.add(prod);
                            if (finalStateMap.containsKey(toState)) {
                                lhs = VAR_START + p + toState + q + VAR_END;
                                rhs = p;
                                lhs2 = String.valueOf(p) + VAR_START + a + q + VAR_END;
                                list.add(new Production(lhs, rhs));
                                list.add(new Production(lhs2, String.valueOf(p) + a));
                                lhs3 = VAR_START + a + q + VAR_END + p;
                                list.add(new Production(lhs3, String.valueOf(a) + rhs));
                            }
                        }
                        direction.equals("S");
                    }
                }
            }
            ++i2;
        }
        Production[] answer = new Production[list.size()];
        int i3 = 0;
        while (i3 < answer.length) {
            answer[i3] = (Production)list.get(i3);
            ++i3;
        }
        return answer;
    }
}

