/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.Transition;
import automata.turing.TMState;
import automata.turing.TMTransition;
import automata.turing.TuringMachineBuildingBlocks;
import gui.action.OpenAction;
import java.awt.Point;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;

public class TuringMachine
extends Automaton {
    private static final long serialVersionUID = 1L;
    public int tapes;
    public boolean isOuterMost;
    private TMState parent = null;

    public TuringMachine() {
        this(1);
    }

    public TuringMachine(int tapes) {
        this.tapes = tapes;
    }

    protected Class getTransitionClass() {
        return TMTransition.class;
    }

    @Override
    public void addTransition(Transition t) {
        try {
            int ttapes = ((TMTransition)t).tapes();
            if (this.tapes == 0) {
                this.tapes = ttapes;
            }
            if (ttapes != this.tapes) {
                throw new IllegalArgumentException("Transition has " + ttapes + " tapes while TM has " + this.tapes);
            }
            super.addTransition(t);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public int tapes() {
        return this.tapes;
    }

    @Override
    public State createState(Point point) {
        return this.createTMState(point);
    }

    @Override
    public Object clone() {
        TMState tms;
        TuringMachine a = new TuringMachine(this.tapes());
        a.setEnvironmentFrame(this.getEnvironmentFrame());
        HashMap<TMState, TMState> map = new HashMap<TMState, TMState>();
        for (Object o : this.states) {
            tms = (TMState)o;
            TMState ntms = new TMState(tms);
            ntms.setAutomaton(a);
            ntms.setLabel(tms.getLabel());
            ntms.setName(tms.getName());
            map.put(tms, ntms);
            a.addState(ntms);
        }
        for (Object o : this.finalStates) {
            tms = (TMState)o;
            a.addFinalState((State)map.get(tms));
        }
        a.setInitialState((TMState)map.get((TMState)this.getInitialState()));
        for (Object o : this.states) {
            tms = (TMState)o;
            Transition[] ts = this.getTransitionsFromState(tms);
            TMState from = (TMState)map.get(tms);
            int i = 0;
            while (i < ts.length) {
                TMState to = (TMState)map.get(ts[i].getToState());
                Transition toBeAdded = (Transition)ts[i].clone();
                toBeAdded.setFromState(from);
                toBeAdded.setToState(to);
                a.addTransition(toBeAdded);
                ++i;
            }
        }
        return a;
    }

    public TMState createBlock(Point point) {
        int i = 0;
        while (this.getStateWithID(i) != null) {
            ++i;
        }
        OpenAction read = new OpenAction();
        OpenAction.setOpenOrRead(true);
        JButton button = new JButton(read);
        button.doClick();
        OpenAction.setOpenOrRead(false);
        return this.getAutomatonFromFile(i, point);
    }

    private TMState getAutomatonFromFile(int i, Point point) {
        TMState block = new TMState(i, point, this);
        Serializable serial = OpenAction.getLastObjectOpened();
        File lastFile = OpenAction.getLastFileOpened();
        if (lastFile == null || !OpenAction.isOpened()) {
            return null;
        }
        assert (serial instanceof TuringMachine);
        TuringMachine tm = (TuringMachine)serial;
        tm.setEnvironmentFrame(this.getEnvironmentFrame());
        block.setInternalName(lastFile.getName());
        block.setName(lastFile.getName().substring(0, lastFile.getName().length() - 4));
        this.addState(block);
        return block;
    }

    public TMState createTMStateWithID(Point p, int i) {
        TMState state = new TMState(i, p, this);
        this.addState(state);
        return state;
    }

    public TMState createTMState(Point point) {
        int i = 0;
        while (this.getStateWithID(i) != null) {
            ++i;
        }
        TMState state = new TMState(i, point, this);
        this.addState(state);
        return state;
    }

    public TMState createInnerTM(Point point, Serializable auto, String name, int i) {
        TMState ntms = new TMState(i, point, this);
        TuringMachineBuildingBlocks innerTM = (TuringMachineBuildingBlocks)auto;
        this.addState(ntms);
        ntms.setInnerTM(innerTM);
        ntms.setInternalName(name);
        return ntms;
    }

    public static void become(TuringMachine dest, TuringMachine src) {
        TMState tms;
        System.out.println("Calling the real become");
        dest.clear();
        HashMap<TMState, TMState> map = new HashMap<TMState, TMState>();
        for (Object o : src.states) {
            System.out.println(o.getClass().getName());
            TMState state = (TMState)o;
            TMState nstate = new TMState(state.getID(), new Point(state.getPoint()), dest);
            nstate.setLabel(state.getLabel());
            nstate.setName(state.getName());
            map.put(state, nstate);
            dest.addState(nstate);
        }
        for (Object o : src.finalStates) {
            tms = (TMState)o;
            dest.addFinalState((State)map.get(tms));
        }
        dest.setInitialState((TMState)map.get((TMState)src.getInitialState()));
        for (Object o : src.states) {
            tms = (TMState)o;
            Transition[] ts = src.getTransitionsFromState(tms);
            TMState from = (TMState)map.get(tms);
            int i = 0;
            while (i < ts.length) {
                TMState to = (TMState)map.get(ts[i].getToState());
                Transition toBeAdded = (Transition)ts[i].clone();
                toBeAdded.setFromState(from);
                toBeAdded.setToState(to);
                dest.addTransition(toBeAdded);
                ++i;
            }
        }
        int k = 0;
        while (k < src.getNotes().size()) {
            Note curNote = src.getNotes().get(k);
            dest.addNote(new Note(curNote.getAutoPoint(), curNote.getText()));
            dest.getNotes().get(k).initializeForView(curNote.getView());
            ++k;
        }
        dest.setEnvironmentFrame(src.getEnvironmentFrame());
    }

    public Map<String, TuringMachine> getBlockMap() {
        HashMap<String, TuringMachine> ret = new HashMap<String, TuringMachine>();
        HashSet<TMState> statesSet = new HashSet<TMState>();
        for (State state : this.states) {
            statesSet.add((TMState)state);
        }
        for (TMState tMState : statesSet) {
            ret.put(tMState.getInternalName(), tMState.getInnerTM());
        }
        return ret;
    }

    public void setParent(TMState tms) {
        this.parent = tms;
    }

    public TMState getParent() {
        return this.parent;
    }
}

