/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import java.io.Serializable;

public class Tape
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StringBuffer buffer = new StringBuffer();
    private int tapeHead;
    private int cachedHash = -559038737;
    public static final char BLANK = '\u25a1';

    public Tape() {
        this("");
    }

    public Tape(String input) {
        this.buffer = new StringBuffer();
        if (input.equals("")) {
            input = "\u25a1";
        }
        this.buffer.insert(0, input);
        this.tapeHead = 0;
    }

    public Tape(Tape tape) {
        this.buffer = new StringBuffer(tape.buffer.toString());
        this.tapeHead = tape.getTapeHead();
        this.cachedHash = tape.cachedHash;
    }

    public void writeChar(char character) {
        this.buffer.deleteCharAt(this.tapeHead);
        this.buffer.insert(this.tapeHead, character);
        this.cachedHash = -559038737;
    }

    public void write(String symbol) {
        this.buffer.deleteCharAt(this.tapeHead);
        this.buffer.insert(this.tapeHead, symbol);
        this.cachedHash = -559038737;
    }

    public char readChar() {
        char[] toReturn = new char[1];
        this.buffer.getChars(this.tapeHead, this.tapeHead + 1, toReturn, 0);
        return toReturn[0];
    }

    public String read() {
        char[] toReturn = new char[1];
        this.buffer.getChars(this.tapeHead, this.tapeHead + 1, toReturn, 0);
        return new String(toReturn);
    }

    public void moveHead(String direction) {
        try {
            switch (direction.charAt(0)) {
                case 'L': {
                    --this.tapeHead;
                    break;
                }
                case 'R': {
                    ++this.tapeHead;
                    break;
                }
                case 'S': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tape direction " + direction);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Tape direction is empty string!");
        }
        if (this.tapeHead >= this.buffer.length()) {
            int bufferLength = this.buffer.length();
            this.buffer.setLength(this.tapeHead + 1);
            int k = bufferLength;
            while (k < this.buffer.length()) {
                this.buffer.deleteCharAt(k);
                this.buffer.insert(k, '\u25a1');
                ++k;
            }
        } else if (this.tapeHead < 0) {
            int numToInsert = Math.abs(this.tapeHead);
            char[] toInsert = new char[numToInsert];
            int i = 0;
            while (i < numToInsert) {
                toInsert[i] = 9633;
                ++i;
            }
            this.buffer.insert(0, toInsert);
            this.tapeHead = 0;
        }
    }

    public String getContents() {
        return this.buffer.toString();
    }

    public String getOutput() {
        int nextBlank = this.buffer.indexOf("\u25a1", this.getTapeHead());
        if (nextBlank == -1) {
            nextBlank = this.buffer.length();
        }
        return this.buffer.substring(this.getTapeHead(), nextBlank);
    }

    public int getTapeHead() {
        return this.tapeHead;
    }

    public String toString() {
        return "[" + this.buffer.toString() + "]" + " TAPE HEAD AT " + this.tapeHead;
    }

    private void nonTrivial(int[] section) {
        int e = this.buffer.length() - 1;
        while (e > 0 && this.buffer.charAt(e) == '\u25a1') {
            --e;
        }
        if (this.buffer.charAt(e) != '\u25a1') {
            ++e;
        }
        int s = 0;
        while (s < e && this.buffer.charAt(s) == '\u25a1') {
            ++s;
        }
        section[0] = s;
        section[1] = e;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object tape) {
        if (tape == this) {
            return true;
        }
        try {
            t = (Tape)tape;
        }
        catch (ClassCastException e) {
            return false;
        }
        first = new int[2];
        second = new int[2];
        this.nonTrivial(first);
        t.nonTrivial(second);
        if (first[1] - first[0] != second[1] - second[0]) {
            return false;
        }
        if (this.tapeHead - first[0] == t.tapeHead - second[0]) ** GOTO lbl20
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.buffer.charAt(first[0]) != t.buffer.charAt(second[0])) {
                return false;
            }
            first[0] = first[0] + 1;
            second[0] = second[0] + 1;
lbl20:
            // 2 sources

            ** while (first[0] < first[1])
        }
lbl21:
        // 1 sources

        return true;
    }

    public int hashCode() {
        if (this.cachedHash != -559038737) {
            return this.cachedHash;
        }
        int[] bounds = new int[2];
        this.nonTrivial(bounds);
        this.cachedHash = this.buffer.substring(bounds[0], bounds[1]).hashCode();
        return this.cachedHash;
    }
}

