/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.State;
import automata.Transition;
import java.util.ArrayList;
import java.util.List;

public class TMTransition
extends Transition {
    private static final long serialVersionUID = 1L;
    private int tapes;
    private boolean blockTransition = false;
    private List<String> toRead;
    private List<String> toWrite;
    private List<String> direction;
    public static final String BLANK = "\u25a1";

    public TMTransition(State from, State to, String ntoRead, String ntoWrite, String ndirection) {
        this(from, to, new String[]{ntoRead}, new String[]{ntoWrite}, new String[]{ndirection});
    }

    public TMTransition(State from, State to, String[] toReadArray, String[] toWriteArray, String[] directionArray) {
        super(from, to);
        if (toReadArray.length != toWriteArray.length || directionArray.length != toReadArray.length) {
            throw new IllegalArgumentException("Read symbols, write symbols, and directions must have equal numbers of elements!");
        }
        this.tapes = toReadArray.length;
        if (this.tapes == 0) {
            throw new IllegalArgumentException("Attempted to create a transition with 0 tapes!");
        }
        this.toRead = new ArrayList<String>();
        this.toWrite = new ArrayList<String>();
        this.direction = new ArrayList<String>();
        int i = 0;
        while (i < this.tapes) {
            this.toRead.add("");
            this.toWrite.add("");
            this.direction.add("");
            this.setRead(toReadArray[i], i);
            this.setWrite(toWriteArray[i], i);
            this.setDirection(directionArray[i], i);
            ++i;
        }
    }

    public int getTapeLength() {
        return this.tapes;
    }

    @Override
    public Transition copy(State from, State to) {
        String[] s = new String[]{};
        return new TMTransition(from, to, this.toRead.toArray(s), this.toWrite.toArray(s), this.direction.toArray(s));
    }

    public String getRead(int tape) {
        return this.toRead.get(tape);
    }

    public void setRead(int tape, String symbol) {
        this.toRead.set(tape, symbol);
    }

    public void setWrite(int tape, String symbol) {
        this.toWrite.set(tape, symbol);
    }

    protected void setRead(String stringToRead, int tape) {
        if (stringToRead.length() == 0) {
            stringToRead = BLANK;
        }
        if (stringToRead.equals("!")) {
            stringToRead = "!\u25a1";
        }
        if (stringToRead.length() != 1 && !stringToRead.startsWith("!") && !stringToRead.equals("~") && stringToRead.indexOf("}") == -1) {
            throw new IllegalArgumentException("Read string must have exactly one character!");
        }
        if (stringToRead.indexOf("}") != -1 && stringToRead.indexOf("!") != -1) {
            throw new IllegalArgumentException("Read string cannot cannot mix variable assignment in the NOT (!) operator.");
        }
        this.toRead.set(tape, stringToRead);
    }

    public String getWrite(int tape) {
        return this.toWrite.get(tape);
    }

    protected void setWrite(String stringToWrite, int tape) {
        if (stringToWrite.length() == 0) {
            stringToWrite = BLANK;
        }
        if (stringToWrite.length() != 1) {
            throw new IllegalArgumentException("Write string must have exactly one character!");
        }
        this.toWrite.set(tape, stringToWrite);
    }

    public String getDirection(int tape) {
        return this.direction.get(tape);
    }

    protected void setDirection(String newDirection, int tape) {
        if (!(newDirection.equals("L") || newDirection.equals("R") || newDirection.equals("S"))) {
            throw new IllegalArgumentException("Direction must be L, R, or S!");
        }
        this.direction.set(tape, newDirection);
    }

    public int tapes() {
        return this.toRead.size();
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        int t = this.tapes();
        int i = 0;
        while (i < t) {
            if (i != 0) {
                sb.append(" | ");
            }
            sb.append(this.toRead.get(i));
            if (!this.blockTransition) {
                sb.append(" ; ");
                sb.append(this.toWrite.get(i));
                sb.append(" , ");
                sb.append(this.direction.get(i));
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ": \"" + this.getDescription() + "\"";
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() ^ this.toRead.hashCode() ^ this.toWrite.hashCode() ^ this.direction.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object object) {
        try {
            TMTransition t = (TMTransition)object;
            return super.equals(object) && this.toRead.equals(t.toRead) && this.toWrite.equals(t.toWrite) && this.direction.equals(t.direction);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean isBlockTransition() {
        return this.blockTransition;
    }

    public void setBlockTransition(boolean block) {
        this.blockTransition = block;
    }
}

