/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.Transition;
import automata.turing.AcceptByFinalStateFilter;
import automata.turing.AcceptByHaltingFilter;
import automata.turing.AcceptanceFilter;
import automata.turing.TMConfiguration;
import automata.turing.TMState;
import automata.turing.TMTransition;
import automata.turing.Tape;
import automata.turing.TuringMachine;
import automata.turing.TuringMachineBuildingBlocks;
import debug.EDebug;
import gui.environment.Universe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class TMSimulator
extends AutomatonSimulator {
    private String[] inputStrings;
    private Map<String, String> varToChar = new HashMap<String, String>();
    private AcceptanceFilter[] myFilters;

    public TMSimulator(Automaton automaton) {
        super(automaton);
        if (!(automaton instanceof TuringMachine)) {
            throw new IllegalArgumentException("Automaton is not a Turing machine, but a " + automaton.getClass());
        }
        ArrayList<AcceptanceFilter> tlist = new ArrayList<AcceptanceFilter>();
        if (Universe.curProfile.getAcceptByFinalState()) {
            tlist.add(new AcceptByFinalStateFilter());
        }
        if (Universe.curProfile.getAcceptByHalting()) {
            tlist.add(new AcceptByHaltingFilter());
        }
        this.myFilters = tlist.toArray(new AcceptanceFilter[0]);
    }

    @Override
    public Configuration[] getInitialConfigurations(String input) {
        int tapes = ((TuringMachine)this.myAutomaton).tapes();
        String[] inputs = new String[tapes];
        int i = 0;
        while (i < tapes) {
            inputs[i] = input;
            ++i;
        }
        return this.getInitialConfigurations(inputs);
    }

    public Configuration[] getInitialConfigurations(String[] inputs) {
        this.inputStrings = (String[])inputs.clone();
        Tape[] tapes = new Tape[inputs.length];
        int i = 0;
        while (i < tapes.length) {
            tapes[i] = new Tape(inputs[i]);
            ++i;
        }
        Configuration[] configs = new Configuration[1];
        TMState initialState = (TMState)this.myAutomaton.getInitialState();
        TuringMachineBuildingBlocks tm = initialState.getInnerTM();
        configs[0] = new TMConfiguration(initialState, null, tapes, this.myFilters);
        return configs;
    }

    private boolean matches(Tape[] tapes, TMTransition tmt) {
        assert (tapes.length == tmt.tapes());
        if (tapes.length > 1) {
            int i = 0;
            while (i < tapes.length) {
                char toMatch;
                char underHead = tapes[i].readChar();
                if (underHead != (toMatch = tmt.getRead(i).charAt(0)) && toMatch != '~') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        assert (tapes.length == 1);
        char underHead = tapes[0].readChar();
        String strtoMatch = tmt.getRead(0);
        int assignIndex = strtoMatch.indexOf(125);
        int bangIndex = strtoMatch.indexOf(33);
        assert (assignIndex == -1 || bangIndex == -1);
        if (assignIndex == -1 && bangIndex == -1) {
            return underHead == strtoMatch.charAt(0) || strtoMatch.charAt(0) == '~';
        }
        if (assignIndex != -1) {
            String[] characters = strtoMatch.substring(0, assignIndex).split(",");
            boolean flag = false;
            int i = 0;
            while (i < characters.length) {
                assert (characters[i].length() == 1);
                if (this.varToChar.containsKey(characters[i])) {
                    JOptionPane.showMessageDialog(null, "You cannot use a variable on the left side of the assignment operator!\n Please fix this and restart the simulation.", "Illegal Variable Location!\n", 0);
                }
                if (characters[i].charAt(0) == underHead) {
                    flag = true;
                }
                ++i;
            }
            if (flag) {
                return flag;
            }
        } else {
            assert (bangIndex == 0);
            return underHead != strtoMatch.charAt(1);
        }
        assert (false);
        return true;
    }

    public List<Configuration> stepBlock(TMConfiguration config) {
        EDebug.print("Inside StepBlock");
        while (((TuringMachine)(config = (TMConfiguration)this.stepConfiguration(config).get(0)).getCurrentState().getAutomaton()).getParent() != null) {
        }
        return Arrays.asList(config);
    }

    @Override
    public ArrayList<Configuration> stepConfiguration(Configuration config) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        TMConfiguration configuration = (TMConfiguration)config;
        TMState currentState = (TMState)configuration.getCurrentState();
        TuringMachine tmp = null;
        int times = 0;
        while ((tmp = currentState.getInnerTM()).getStates().length != 0) {
            EDebug.print(times++);
            currentState = (TMState)tmp.getInitialState();
            if (currentState != null) continue;
            JOptionPane.showMessageDialog(null, "It appears that one of your building blocks, possibly nested, lacks an initial state.\n Please resolve this problem and restart the simulation.", "Missing Initial State", 0);
            return list;
        }
        assert (tmp == currentState.getInnerTM());
        assert (tmp.getParent() == currentState);
        Transition[] trans = currentState.getAutomaton().getTransitionsFromState(currentState);
        TMTransition tmt = null;
        boolean success = false;
        block1: while (true) {
            Arrays.sort(trans, new Comparator<Transition>(){

                @Override
                public int compare(Transition a, Transition b) {
                    TMTransition tma = (TMTransition)a;
                    TMTransition tmb = (TMTransition)b;
                    char fa = tma.getRead(0).charAt(0);
                    char fb = tmb.getRead(0).charAt(0);
                    return fa == '!' ? (fb == '!' ? 0 : 1) : (fb == '!' ? 1 : 0);
                }
            });
            int i = 0;
            while (i < trans.length) {
                tmt = (TMTransition)trans[i];
                if (this.matches(configuration.getTapes(), tmt)) {
                    success = true;
                    break block1;
                }
                ++i;
            }
            if (tmp.getParent() == null) break;
            currentState = tmp.getParent();
            tmp = (TuringMachine)currentState.getAutomaton();
            trans = tmp.getTransitionsFromState(currentState);
        }
        if (success) {
            if (configuration.getTapes().length > 1) {
                int k = 0;
                while (k < configuration.getTapes().length) {
                    configuration.getTapes()[k].writeChar(tmt.getWrite(k).charAt(0) == '~' ? configuration.getTapes()[k].readChar() : tmt.getWrite(k).charAt(0));
                    configuration.getTapes()[k].moveHead(tmt.getDirection(k));
                    list.add(new TMConfiguration(tmt.getToState(), null, configuration.getTapes(), this.myFilters));
                    ++k;
                }
            } else {
                String st = tmt.getRead(0);
                int assignIndex = st.indexOf(125);
                if (assignIndex != -1) {
                    String s = "" + st.charAt(assignIndex + 1);
                    this.varToChar.put(s, String.valueOf(configuration.getTapes()[0].readChar()));
                }
                configuration.getTapes()[0].writeChar(tmt.getWrite(0).charAt(0) == '~' ? configuration.getTapes()[0].readChar() : (this.varToChar.containsKey(String.valueOf(tmt.getWrite(0).charAt(0))) ? this.varToChar.get(String.valueOf(tmt.getWrite(0).charAt(0))).charAt(0) : tmt.getWrite(0).charAt(0)));
                configuration.getTapes()[0].moveHead(tmt.getDirection(0));
                list.add(new TMConfiguration(tmt.getToState(), null, configuration.getTapes(), this.myFilters));
            }
        } else if (!configuration.isHalted()) {
            configuration.setHalted(true);
            list.add(configuration);
        }
        return list;
    }

    @Override
    public boolean isAccepted() {
        return false;
    }

    @Override
    public boolean simulateInput(String input) {
        this.myConfigurations.clear();
        Configuration[] initialConfigs = this.getInitialConfigurations(input);
        int k = 0;
        while (k < initialConfigs.length) {
            TMConfiguration initialConfiguration = (TMConfiguration)initialConfigs[k];
            this.myConfigurations.add(initialConfiguration);
            ++k;
        }
        while (!this.myConfigurations.isEmpty()) {
            if (this.isAccepted()) {
                return true;
            }
            ArrayList<Configuration> configurationsToAdd = new ArrayList<Configuration>();
            Iterator it = this.myConfigurations.iterator();
            while (it.hasNext()) {
                TMConfiguration configuration = (TMConfiguration)it.next();
                ArrayList<Configuration> configsToAdd = this.stepConfiguration(configuration);
                configurationsToAdd.addAll(configsToAdd);
                it.remove();
            }
            this.myConfigurations.addAll(configurationsToAdd);
        }
        return false;
    }

    public String[] getInputStrings() {
        return this.inputStrings;
    }
}

