/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Configuration;
import automata.State;
import automata.turing.AcceptanceFilter;
import automata.turing.Tape;

public class TMConfiguration
extends Configuration
implements Cloneable {
    protected Tape[] myTapes;
    private AcceptanceFilter[] myFilters;
    private boolean isHalted = false;

    public TMConfiguration(State state, TMConfiguration parent, Tape[] tapes, AcceptanceFilter[] filters) {
        super(state, parent);
        this.myTapes = tapes;
        this.myFilters = filters;
    }

    public Tape[] getTapes() {
        return this.myTapes;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        int i = 0;
        while (i < this.myTapes.length) {
            sb.append(" TAPE ");
            sb.append(i);
            sb.append(": ");
            sb.append(this.myTapes[i].toString());
            ++i;
        }
        return sb.toString();
    }

    @Override
    public boolean isAccept() {
        int i = 0;
        while (i < this.myFilters.length) {
            if (this.myFilters[i].accept(this)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object configuration) {
        if (configuration == this) {
            return true;
        }
        try {
            if (!super.equals(configuration)) {
                return false;
            }
            Tape[] tapes = ((TMConfiguration)configuration).myTapes;
            if (tapes.length != this.myTapes.length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= tapes.length) {
                    return true;
                }
                if (!tapes[i].equals(this.myTapes[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        int i = 0;
        while (i < this.myTapes.length) {
            code ^= this.myTapes[i].hashCode();
            ++i;
        }
        return code;
    }

    public boolean isHalted() {
        return this.isHalted;
    }

    public void setHalted(boolean b) {
        this.isHalted = b;
    }

    public Object clone() {
        TMConfiguration newConfig = new TMConfiguration(this.getCurrentState(), (TMConfiguration)this.getParent(), this.myTapes, this.myFilters);
        newConfig.setFocused(this.getFocused());
        newConfig.setHalted(this.isHalted());
        return newConfig;
    }
}

