/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.turing.AcceptByFinalStateFilter;
import automata.turing.AcceptByHaltingFilter;
import automata.turing.AcceptanceFilter;
import automata.turing.TMConfiguration;
import automata.turing.TMState;
import automata.turing.TMTransition;
import automata.turing.Tape;
import automata.turing.TuringMachine;
import automata.turing.TuringMachineBuildingBlocks;
import gui.environment.Universe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class NDTMSimulator
extends AutomatonSimulator {
    private AcceptanceFilter[] myFilters;
    private String[] inputStrings;

    public NDTMSimulator(Automaton automaton) {
        super(automaton);
        if (!(automaton instanceof TuringMachine)) {
            throw new IllegalArgumentException("Automaton is not a Turing machine, but a " + automaton.getClass());
        }
        ArrayList<AcceptanceFilter> tlist = new ArrayList<AcceptanceFilter>();
        if (Universe.curProfile.getAcceptByFinalState()) {
            tlist.add(new AcceptByFinalStateFilter());
        }
        if (Universe.curProfile.getAcceptByHalting()) {
            tlist.add(new AcceptByHaltingFilter());
        }
        this.myFilters = tlist.toArray(new AcceptanceFilter[0]);
    }

    @Override
    public Configuration[] getInitialConfigurations(String input) {
        int tapes = ((TuringMachine)this.myAutomaton).tapes();
        String[] inputs = new String[tapes];
        int i = 0;
        while (i < tapes) {
            inputs[i] = input;
            ++i;
        }
        return this.getInitialConfigurations(inputs);
    }

    public Configuration[] getInitialConfigurations(String[] inputs) {
        this.inputStrings = (String[])inputs.clone();
        Tape[] tapes = new Tape[inputs.length];
        int i = 0;
        while (i < tapes.length) {
            tapes[i] = new Tape(inputs[i]);
            ++i;
        }
        Configuration[] configs = new Configuration[1];
        TMState initialState = (TMState)this.myAutomaton.getInitialState();
        TuringMachineBuildingBlocks tm = initialState.getInnerTM();
        configs[0] = new TMConfiguration(initialState, null, tapes, this.myFilters);
        return configs;
    }

    @Override
    public ArrayList<Configuration> stepConfiguration(Configuration config) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        TMConfiguration configuration = (TMConfiguration)config;
        State currentState = configuration.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int k = 0;
        while (k < transitions.length) {
            TMTransition t = (TMTransition)transitions[k];
            Tape[] tapes = configuration.getTapes();
            boolean okay = true;
            int i = 0;
            while (okay && i < tapes.length) {
                String toRead;
                String charAtHead = tapes[i].read();
                if (!charAtHead.equals(toRead = t.getRead(i))) {
                    okay = false;
                }
                ++i;
            }
            if (okay) {
                State toState = t.getToState();
                Tape[] tapes2 = new Tape[tapes.length];
                int i2 = 0;
                while (i2 < tapes.length) {
                    tapes2[i2] = new Tape(tapes[i2]);
                    String toWrite = t.getWrite(i2);
                    String direction = t.getDirection(i2);
                    tapes2[i2].write(toWrite);
                    tapes2[i2].moveHead(direction);
                    ++i2;
                }
                TMConfiguration configurationToAdd = new TMConfiguration(toState, configuration, tapes2, this.myFilters);
                list.add(configurationToAdd);
            }
            ++k;
        }
        return list;
    }

    @Override
    public boolean isAccepted() {
        for (TMConfiguration configuration : this.myConfigurations) {
            State currentState = configuration.getCurrentState();
            if (!this.myAutomaton.isFinalState(currentState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean simulateInput(String input) {
        this.myConfigurations.clear();
        Configuration[] initialConfigs = this.getInitialConfigurations(input);
        int k = 0;
        while (k < initialConfigs.length) {
            TMConfiguration initialConfiguration = (TMConfiguration)initialConfigs[k];
            this.myConfigurations.add(initialConfiguration);
            ++k;
        }
        while (!this.myConfigurations.isEmpty()) {
            if (this.isAccepted()) {
                return true;
            }
            ArrayList<Configuration> configurationsToAdd = new ArrayList<Configuration>();
            Iterator it = this.myConfigurations.iterator();
            while (it.hasNext()) {
                TMConfiguration configuration = (TMConfiguration)it.next();
                ArrayList<Configuration> configsToAdd = this.stepConfiguration(configuration);
                configurationsToAdd.addAll(configsToAdd);
                it.remove();
            }
            this.myConfigurations.addAll(configurationsToAdd);
        }
        return false;
    }

    public List<TMConfiguration> stepBlock(TMConfiguration config) {
        while (((TuringMachine)(config = (TMConfiguration)this.stepConfiguration(config).get(0)).getCurrentState().getAutomaton()).getParent() != null) {
        }
        return Arrays.asList(config);
    }

    public String[] getInputStrings() {
        return this.inputStrings;
    }
}

