/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import java.io.Serializable;

public class CharacterStack
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StringBuffer buffer = new StringBuffer();
    private int cachedHash = -559038737;

    public CharacterStack() {
    }

    public CharacterStack(CharacterStack stack) {
        this.buffer = new StringBuffer(stack.buffer.toString());
    }

    public void push(char character) {
        this.buffer.insert(0, character);
        this.cachedHash = -559038737;
    }

    public void push(String string) {
        this.buffer.insert(0, string);
        this.cachedHash = -559038737;
    }

    public void clear() {
        this.buffer = new StringBuffer();
        this.cachedHash = -559038737;
    }

    public int height() {
        return this.buffer.length();
    }

    public char pop() {
        char[] toReturn = new char[1];
        this.buffer.getChars(0, 1, toReturn, 0);
        this.buffer.deleteCharAt(0);
        return toReturn[0];
    }

    public String pop(int number) {
        if (this.buffer.length() < number) {
            return null;
        }
        char[] c = new char[number];
        this.buffer.getChars(0, number, c, 0);
        this.buffer.delete(0, number);
        return new String(c);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public boolean equals(Object stack) {
        try {
            return ((CharacterStack)stack).buffer.toString().equals(this.buffer.toString());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        if (this.cachedHash != -559038737) {
            return this.cachedHash;
        }
        this.cachedHash = this.buffer.toString().hashCode();
        return this.cachedHash;
    }
}

