/*
 * Decompiled with CFR 0.152.
 */
package automata.mealy;

import automata.State;
import automata.Transition;
import gui.environment.Universe;

public class MealyTransition
extends Transition {
    private static final long serialVersionUID = 1L;
    protected String myLabel;
    protected String myOutput;

    public MealyTransition(State from, State to, String label, String output) {
        super(from, to);
        this.setLabel(label);
        this.setOutput(output);
    }

    @Override
    public Transition copy(State from, State to) {
        return new MealyTransition(from, to, this.myLabel, this.myOutput);
    }

    protected void setLabel(String label) {
        this.myLabel = label == null ? "" : label;
    }

    protected void setOutput(String output) {
        this.myOutput = output == null ? "" : output;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getOutput() {
        return this.myOutput;
    }

    @Override
    public String getDescription() {
        String label = this.getLabel();
        String output = this.getOutput();
        if (label == null || label.length() == 0) {
            label = Universe.curProfile.getEmptyString();
        }
        if (output == null || output.length() == 0) {
            output = Universe.curProfile.getEmptyString();
        }
        return String.valueOf(label) + " ; " + output;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ": \"" + this.getLabel() + "/" + this.getOutput() + "\"";
    }

    @Override
    public boolean equals(Object object) {
        try {
            MealyTransition t = (MealyTransition)object;
            return super.equals(t) && this.getLabel().equals(t.getLabel()) && this.getOutput().equals(t.getOutput());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getLabel().hashCode() ^ this.getOutput().hashCode();
    }
}

