/*
 * Decompiled with CFR 0.152.
 */
package automata.mealy;

import automata.Configuration;
import automata.State;

public class MealyConfiguration
extends Configuration {
    private String myInput = "";
    private String myUnprocessedInput = "";
    private String myOutput = "";

    public MealyConfiguration(State state, MealyConfiguration parent, String input, String unprocessed, String output) {
        super(state, parent);
        this.myInput = input;
        this.myUnprocessedInput = unprocessed;
        this.myOutput = output;
    }

    public String getInput() {
        return this.myInput;
    }

    public String getUnprocessedInput() {
        return this.myUnprocessedInput;
    }

    public String getOutput() {
        return this.myOutput;
    }

    public void setUnprocessedInput(String input) {
        this.myUnprocessedInput = input;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.getUnprocessedInput() + "--" + this.getOutput();
    }

    @Override
    public boolean isAccept() {
        return this.getUnprocessedInput().length() == 0;
    }

    @Override
    public boolean equals(Object configuration) {
        if (configuration == this) {
            return true;
        }
        try {
            MealyConfiguration config = (MealyConfiguration)configuration;
            return super.equals(config) && this.myUnprocessedInput.equals(config.myUnprocessedInput) && this.myOutput.equals(config.myOutput);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.myUnprocessedInput.hashCode() ^ this.myOutput.hashCode();
    }
}

