/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JOptionPane;

public class VertexMover
extends LayoutAlgorithm {
    public static final int HORIZONTAL_CENTER = -10;
    public static final int VERTICAL_CENTER = -11;
    public static final int POSITIVE_SLOPE_DIAGONAL = -12;
    public static final int NEGATIVE_SLOPE_DIAGONAL = -13;
    public static final int ROTATE = -14;
    public static final int FILL = -15;
    private int command;

    public VertexMover(int c) {
        this.command = c;
    }

    public VertexMover(Dimension pSize, Dimension vDim, double vBuffer, int c) {
        super(pSize, vDim, vBuffer);
        this.command = c;
    }

    @Override
    public void layout(Graph graph, Set<Object> notMoving) {
        ArrayList<Object> vertices = VertexMover.getMovableVertices(graph, notMoving);
        if (this.command == -15) {
            VertexMover.shiftOntoScreen(graph, this.size, this.vertexDim, false);
            return;
        }
        if (this.command == -10) {
            int i = 0;
            while (i < vertices.size()) {
                Point2D point = graph.pointForVertex(vertices.get(i));
                graph.moveVertex(vertices.get(i), new Point2D.Double(point.getX(), this.size.getHeight() - point.getY()));
                ++i;
            }
        } else if (this.command == -11) {
            int i = 0;
            while (i < vertices.size()) {
                Point2D point = graph.pointForVertex(vertices.get(i));
                graph.moveVertex(vertices.get(i), new Point2D.Double(this.size.getWidth() - point.getX(), point.getY()));
                ++i;
            }
        } else if (this.command == -12) {
            int i = 0;
            while (i < vertices.size()) {
                Point2D point = graph.pointForVertex(vertices.get(i));
                graph.moveVertex(vertices.get(i), new Point2D.Double(point.getY(), point.getX()));
                ++i;
            }
        } else if (this.command == -13) {
            int i = 0;
            while (i < vertices.size()) {
                Point2D point = graph.pointForVertex(vertices.get(i));
                graph.moveVertex(vertices.get(i), new Point2D.Double(this.size.getWidth() - point.getY(), this.size.getHeight() - point.getX()));
                ++i;
            }
        } else if (this.command == -14) {
            double theta = 0.0;
            try {
                String input = JOptionPane.showInputDialog("How many degrees to turn the automaton? \n(positive - clockwise, negative - counterclockwise)", (Object)new String("180"));
                theta = Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "That is not a valid degree value.", "Invalid Input", 0);
                return;
            }
            catch (NullPointerException e) {
                return;
            }
            VertexMover.cartesianToPolar(graph, vertices);
            int i = 0;
            while (i < vertices.size()) {
                Point2D point = graph.pointForVertex(vertices.get(i));
                graph.moveVertex(vertices.get(i), new Point2D.Double(point.getX(), point.getY() + theta / -180.0 * Math.PI));
                ++i;
            }
            VertexMover.polarToCartesian(graph, vertices);
        }
        VertexMover.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }
}

