/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.AutomatonDirectedGraph;
import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class TreeLayoutAlgorithm
extends LayoutAlgorithm {
    protected Graph graph;
    protected boolean hierarchical;

    public TreeLayoutAlgorithm(boolean hier) {
        this.hierarchical = hier;
    }

    public TreeLayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer, boolean hier) {
        super(pSize, vDim, vBuffer);
        this.hierarchical = hier;
    }

    @Override
    public void layout(Graph g, Set<Object> notMoving) {
        this.graph = g;
        ArrayList<Object> vertices = TreeLayoutAlgorithm.getMovableVertices(this.graph, notMoving);
        if (this.graph == null || vertices.size() == 0) {
            return;
        }
        if (this.hierarchical) {
            if (!(this.graph instanceof AutomatonDirectedGraph)) {
                return;
            }
            final AutomatonDirectedGraph adg = (AutomatonDirectedGraph)this.graph;
            Collections.sort(vertices, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (adg.toDegree(o1, true) == adg.toDegree(o2, true)) {
                        return 0;
                    }
                    if (adg.toDegree(o1, true) > adg.toDegree(o2, true)) {
                        return 1;
                    }
                    return -1;
                }
            });
        } else {
            Collections.sort(vertices, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (TreeLayoutAlgorithm.this.graph.degree(o1) == TreeLayoutAlgorithm.this.graph.degree(o2)) {
                        return 0;
                    }
                    if (TreeLayoutAlgorithm.this.graph.degree(o1) > TreeLayoutAlgorithm.this.graph.degree(o2)) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        ArrayList<Object> notPlaced = new ArrayList<Object>();
        notPlaced.addAll(vertices);
        Level firstLevel = new Level();
        while (notPlaced.size() > 0) {
            firstLevel.vertices.add(notPlaced.get(0));
            notPlaced.remove(notPlaced.get(0));
            Level counter = firstLevel;
            while (counter != null && notPlaced.size() > 0) {
                counter.processChildren(notPlaced);
                counter = counter.nextLevel;
            }
        }
        firstLevel.layout(0.0);
        TreeLayoutAlgorithm.shiftOntoScreen(this.graph, this.size, this.vertexDim, true);
    }

    private class Level {
        public ArrayList<Object> vertices = new ArrayList();
        public Level nextLevel = null;

        public void processChildren(ArrayList<Object> notPlaced) {
            VertexChain lastChain = null;
            int i = 0;
            while (i < this.vertices.size()) {
                VertexChain chain = new VertexChain(TreeLayoutAlgorithm.this.graph);
                int j = notPlaced.size() - 1;
                while (j >= 0) {
                    if (TreeLayoutAlgorithm.this.graph.hasEdge(this.vertices.get(i), notPlaced.get(j)) && !this.vertices.get(i).equals(notPlaced.get(j))) {
                        chain.addVertex(notPlaced.get(j));
                        notPlaced.remove(j);
                    }
                    --j;
                }
                if (lastChain != null) {
                    VertexChain.alignTwoChains(lastChain, chain, TreeLayoutAlgorithm.this.graph);
                    if (lastChain.size() > 0) {
                        if (this.nextLevel == null) {
                            this.nextLevel = new Level();
                        }
                        this.nextLevel.vertices.addAll(lastChain.getVertices());
                    }
                }
                lastChain = chain;
                ++i;
            }
            if (lastChain != null && lastChain.size() > 0) {
                if (this.nextLevel == null) {
                    this.nextLevel = new Level();
                }
                this.nextLevel.vertices.addAll(lastChain.getVertices());
            }
        }

        public void layout(double height) {
            double currentX = -1.0 * (double)this.vertices.size() * (TreeLayoutAlgorithm.this.vertexDim.getWidth() + TreeLayoutAlgorithm.this.vertexBuffer) / 2.0;
            int i = 0;
            while (i < this.vertices.size()) {
                TreeLayoutAlgorithm.this.graph.moveVertex(this.vertices.get(i), new Point2D.Double(currentX, height));
                currentX += TreeLayoutAlgorithm.this.vertexBuffer + TreeLayoutAlgorithm.this.vertexDim.getWidth();
                ++i;
            }
            if (this.nextLevel != null) {
                this.nextLevel.layout(height + TreeLayoutAlgorithm.this.vertexDim.getHeight() + TreeLayoutAlgorithm.this.vertexBuffer);
            }
        }
    }
}

