/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Set;

public class RandomLayoutAlgorithm
extends LayoutAlgorithm {
    private ArrayList<Object> vertices;
    private ArrayList<Object> points;
    private VertexChain chain;

    public RandomLayoutAlgorithm() {
    }

    public RandomLayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer) {
        super(pSize, vDim, vBuffer);
    }

    @Override
    public void layout(Graph graph, Set<Object> notMoving) {
        this.vertices = RandomLayoutAlgorithm.getMovableVertices(graph, notMoving);
        if (graph == null || this.vertices.size() == 0) {
            return;
        }
        this.chain = new VertexChain(graph);
        this.assignPointsAndVertices();
        this.lessenVertexOverlap();
        this.findCorrectPointOrder();
        int i = 0;
        while (i < this.points.size()) {
            graph.moveVertex(this.chain.get(i), (Point2D)this.points.get(i));
            ++i;
        }
        RandomLayoutAlgorithm.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }

    private void assignPointsAndVertices() {
        Random random = new Random();
        this.points = new ArrayList();
        int i = 0;
        while (i < this.vertices.size()) {
            double x = random.nextDouble() * (this.size.getWidth() - this.vertexBuffer * 2.0);
            double y = random.nextDouble() * (this.size.getHeight() - this.vertexBuffer * 2.0);
            this.points.add(new Point2D.Double(x, y));
            this.chain.addVertex(this.vertices.get(i));
            ++i;
        }
    }

    private void lessenVertexOverlap() {
        ArrayList<Object> xOrder = new ArrayList<Object>();
        ArrayList<Object> yOrder = new ArrayList<Object>();
        xOrder.addAll(this.points);
        yOrder.addAll(this.points);
        Collections.sort(xOrder, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((Point2D)o1).getX() == ((Point2D)o2).getX()) {
                    return 0;
                }
                if (((Point2D)o1).getX() < ((Point2D)o2).getX()) {
                    return 1;
                }
                return -1;
            }
        });
        Collections.sort(yOrder, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((Point2D)o1).getY() == ((Point2D)o2).getY()) {
                    return 0;
                }
                if (((Point2D)o1).getY() < ((Point2D)o2).getY()) {
                    return 1;
                }
                return -1;
            }
        });
        double xBuffer = this.vertexDim.getWidth() + this.vertexBuffer;
        double yBuffer = this.vertexDim.getHeight() + this.vertexBuffer;
        int i = 0;
        while (i < this.vertices.size() - 1) {
            Point2D point;
            int j;
            double xDiff = ((Point2D)xOrder.get(i)).getX() - ((Point2D)xOrder.get(i + 1)).getX();
            double yDiff = ((Point2D)xOrder.get(i)).getY() - ((Point2D)xOrder.get(i + 1)).getY();
            if (xDiff < xBuffer && yDiff < yBuffer) {
                j = i;
                while (j >= 0) {
                    point = (Point2D)xOrder.get(j);
                    point.setLocation(point.getX() + xBuffer - xDiff, point.getY());
                    --j;
                }
            }
            xDiff = ((Point2D)yOrder.get(i)).getX() - ((Point2D)yOrder.get(i + 1)).getX();
            yDiff = ((Point2D)yOrder.get(i)).getY() - ((Point2D)yOrder.get(i + 1)).getY();
            if (xDiff < xBuffer && yDiff < yBuffer) {
                j = i;
                while (j >= 0) {
                    point = (Point2D)yOrder.get(j);
                    point.setLocation(point.getX(), point.getY() + yBuffer - yDiff);
                    --j;
                }
            }
            ++i;
        }
    }

    private void findCorrectPointOrder() {
        Point2D anchor = new Point2D.Double(0.0, 0.0);
        double anchorTheta = 0.0;
        ArrayList<Point2D> newPointOrder = new ArrayList<Point2D>();
        ArrayList<Object> notProcessedPoints = new ArrayList<Object>();
        notProcessedPoints.addAll(this.points);
        while (notProcessedPoints.size() > 0) {
            Point2D minPoint = (Point2D)notProcessedPoints.get(0);
            double minTheta = 7.283185307179586;
            int i = 0;
            while (i < notProcessedPoints.size()) {
                Point2D current = (Point2D)notProcessedPoints.get(i);
                double currentTheta = current.getY() != anchor.getY() ? Math.atan((current.getX() - anchor.getX()) / (current.getY() - anchor.getY())) : (current.getX() > anchor.getX() ? 1.5707963267948966 : -1.5707963267948966);
                if ((currentTheta = (currentTheta + Math.PI * 4 - anchorTheta) % Math.PI) < minTheta) {
                    minTheta = currentTheta;
                    minPoint = current;
                }
                ++i;
            }
            anchor = minPoint;
            anchorTheta = (anchorTheta + minTheta) % (Math.PI * 2);
            notProcessedPoints.remove(minPoint);
            newPointOrder.add(minPoint);
        }
        this.points = newPointOrder;
    }
}

