/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class GEMLayoutAlgorithm
extends LayoutAlgorithm {
    private static final Random RANDOM = new Random();
    private Map<Object, Record> records;
    private static final Set<Object> EMPTY_SET = new HashSet<Object>();
    private static final double Tmax = 256.0;
    private static final double Tmin = 3.0;
    private static final double OPTIMAL_EDGE_LENGTH = 100.0;
    private static final double GRAVITATIONAL_CONSTANT = 0.0625;

    public GEMLayoutAlgorithm() {
    }

    public GEMLayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer) {
        super(pSize, vDim, vBuffer);
    }

    @Override
    public void layout(Graph graph, Set<Object> isovertices) {
        if (isovertices == null) {
            isovertices = EMPTY_SET;
        }
        Object[] vArray = graph.vertices();
        int Rmax = 120 * (vArray.length - isovertices.size());
        double Tglobal = 4.0;
        double optimalEdgeLength = 100.0;
        if (isovertices.size() > 0) {
            Object[] iso = isovertices.toArray();
            int count = 0;
            double lengths = 0.0;
            int i = 0;
            while (i < iso.length) {
                int j = i + 1;
                while (j < iso.length) {
                    if (graph.hasEdge(iso[i], iso[j])) {
                        lengths += graph.pointForVertex(iso[i]).distance(graph.pointForVertex(iso[j]));
                        ++count;
                    }
                    ++j;
                }
                ++i;
            }
            if (count > 0) {
                optimalEdgeLength = lengths / (double)count;
            }
        }
        double[] c = new double[]{0.0, 0.0};
        this.records = new HashMap<Object, Record>();
        int i = 0;
        while (i < vArray.length) {
            Record r = new Record();
            r.point = graph.pointForVertex(vArray[i]);
            c[0] = c[0] + r.point.getX();
            c[1] = c[1] + r.point.getY();
            this.records.put(vArray[i], r);
            ++i;
        }
        ArrayList<Object> vertices = new ArrayList();
        int i2 = 0;
        while (i2 < Rmax && Tglobal > 3.0) {
            if (vertices.isEmpty() && (vertices = GEMLayoutAlgorithm.getMovableVertices(graph, isovertices)).size() == 0) {
                return;
            }
            int index = RANDOM.nextInt(vertices.size());
            Object vertex = vertices.remove(index);
            Record record = this.records.get(vertex);
            Point2D point = graph.pointForVertex(vertex);
            double Theta = graph.degree(vertex);
            Theta *= 1.0 + Theta / 2.0;
            double[] p = new double[]{(c[0] / (double)graph.numberOfVertices() - point.getX()) * 0.0625 * Theta, (c[1] / (double)graph.numberOfVertices() - point.getY()) * 0.0625 * Theta};
            p[0] = p[0] + (RANDOM.nextDouble() * 10.0 - 5.0);
            p[1] = p[1] + (RANDOM.nextDouble() * 10.0 - 5.0);
            int j = 0;
            while (j < vArray.length) {
                if (vArray[j] != vertex) {
                    int k;
                    Point2D otherPoint = graph.pointForVertex(vArray[j]);
                    double[] delta = new double[]{point.getX() - otherPoint.getX(), point.getY() - otherPoint.getY()};
                    double D2 = delta[0] * delta[0] + delta[1] * delta[1];
                    double O2 = optimalEdgeLength * optimalEdgeLength;
                    if (delta[0] != 0.0 || delta[1] != 0.0) {
                        k = 0;
                        while (k < 2) {
                            int n = k;
                            p[n] = p[n] + delta[k] * O2 / D2;
                            ++k;
                        }
                    }
                    if (graph.hasEdge(vertex, vArray[j])) {
                        k = 0;
                        while (k < 2) {
                            int n = k;
                            p[n] = p[n] - delta[k] * D2 / (O2 * Theta);
                            ++k;
                        }
                    }
                }
                ++j;
            }
            if (p[0] != 0.0 || p[1] != 0.0) {
                double absp = Math.sqrt(Math.abs(p[0] * p[0] + p[1] * p[1]));
                int j2 = 0;
                while (j2 < 2) {
                    int n = j2++;
                    p[n] = p[n] * (record.temperature / absp);
                }
                graph.moveVertex(vertex, new Point2D.Double(point.getX() + p[0], point.getY() + p[1]));
                c[0] = c[0] + p[0];
                c[1] = c[1] + p[1];
            }
            ++i2;
        }
        GEMLayoutAlgorithm.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }

    public static class Record {
        Point2D point = new Point2D.Double();
        double[] lastImpulse = new double[]{0.0, 0.0};
        double temperature = 3.0;
        double skew = 0.0;
    }
}

