/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.CircleChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Set;

public class CircleLayoutAlgorithm
extends LayoutAlgorithm {
    private ArrayList<Box> boxes;

    public CircleLayoutAlgorithm() {
    }

    public CircleLayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer) {
        super(pSize, vDim, vBuffer);
    }

    @Override
    public void layout(Graph graph, Set<Object> notMoving) {
        ArrayList<Object> vertices = CircleLayoutAlgorithm.getMovableVertices(graph, notMoving);
        if (graph == null || vertices.size() == 0) {
            return;
        }
        this.boxes = new ArrayList();
        int i = 0;
        while (i < vertices.size()) {
            if (!this.addToExistingBox(vertices.get(i))) {
                Box box = new Box(graph, this.vertexDim, this.vertexBuffer);
                box.addVertex(vertices.get(i));
                this.boxes.add(box);
            }
            ++i;
        }
        i = this.boxes.size() - 1;
        while (i > 0) {
            this.mergeIfPossible(this.boxes.get(i), i);
            --i;
        }
        i = 0;
        while (i < this.boxes.size()) {
            this.boxes.get(i).layoutInCircleAndPack();
            ++i;
        }
        CircleLayoutAlgorithm.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }

    private boolean addToExistingBox(Object vertex) {
        int i = 0;
        while (i < this.boxes.size()) {
            if (this.boxes.get(i).isEdgeToChainMember(vertex)) {
                this.boxes.get(i).addVertex(vertex);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void mergeIfPossible(Box current, int max) {
        int j = max - 1;
        while (j >= 0) {
            Box toSearch = this.boxes.get(j);
            int k = 0;
            while (k < current.size()) {
                if (toSearch.isEdgeToChainMember(current.get(k))) {
                    toSearch.merge(current);
                    this.boxes.remove(current);
                    return;
                }
                ++k;
            }
            --j;
        }
    }

    public class Box
    extends CircleChain {
        public Dimension size;
        public Box down;
        public Box right;
        public Point2D upperLeft;

        public Box(Graph g, Dimension vDim, double vBuffer) {
            super(g, vDim, vBuffer);
            this.upperLeft = new Point2D.Double(0.0, 0.0);
            this.right = null;
            this.down = null;
        }

        public void merge(Box b) {
            int i = 0;
            while (i < b.size()) {
                this.addVertex(b.get(i));
                ++i;
            }
        }

        public void setUpperLeft(Box current) {
            if (this.size.getHeight() <= current.size.getHeight()) {
                this.upperLeft = new Point2D.Double(this.upperLeft.getX() + current.size.getWidth(), this.upperLeft.getY());
                while (current.right != null) {
                    current = current.right;
                    this.upperLeft = new Point2D.Double(this.upperLeft.getX() + current.size.getWidth(), this.upperLeft.getY());
                }
                current.right = this;
                return;
            }
            this.upperLeft = new Point2D.Double(this.upperLeft.getX(), this.upperLeft.getY() + current.size.getHeight());
            if (current.down == null) {
                current.down = this;
            } else {
                this.setUpperLeft(current.down);
            }
        }

        public void layoutInCircleAndPack() {
            this.layoutInCircle();
            CircleLayoutAlgorithm.polarToCartesian(this.graph, this.getVertices());
            this.size = new Dimension((int)(2.0 * (this.getRadius() + this.vertexBuffer) + (double)this.vertexDim.width), (int)(2.0 * (this.getRadius() + this.vertexBuffer) + (double)this.vertexDim.height));
            if (CircleLayoutAlgorithm.this.boxes.indexOf(this) != 0) {
                this.setUpperLeft((Box)CircleLayoutAlgorithm.this.boxes.get(0));
                int i = 0;
                while (i < this.size()) {
                    this.graph.moveVertex(this.get(i), new Point2D.Double(this.upperLeft.getX() + this.graph.pointForVertex(this.get(i)).getX(), this.upperLeft.getY() + this.graph.pointForVertex(this.get(i)).getY()));
                    ++i;
                }
            }
        }
    }
}

