/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CircleChain
extends VertexChain {
    protected double radius = 0.0;
    protected Dimension vertexDim;
    protected double vertexBuffer;

    public CircleChain(Graph g, Dimension vDim, double vBuffer) {
        super(g);
        this.vertexDim = vDim;
        this.vertexBuffer = vBuffer;
    }

    public double getRadius() {
        return this.radius;
    }

    public void layoutInCircle() {
        this.layout(0.0, Math.PI, Math.PI * 2);
    }

    public void layout(double r, double midTheta, double span) {
        double diagonalLength = Math.sqrt(Math.pow(this.vertexDim.getHeight(), 2.0) + Math.pow(this.vertexDim.getWidth(), 2.0)) + this.vertexBuffer;
        if (this.size() == 0) {
            return;
        }
        if (this.size() == 1) {
            if (r == 0.0) {
                this.graph.moveVertex(this.vertices.get(0), new Point2D.Double(0.0, 0.0));
            } else {
                this.graph.moveVertex(this.vertices.get(0), new Point2D.Double(r + diagonalLength, midTheta));
            }
            return;
        }
        double startTheta = midTheta - span / 2.0;
        int divisions = Math.PI * 2 - span < 1.0E-4 ? this.size() : this.size() - 1;
        double thetaDivision = span / (double)divisions;
        this.radius = diagonalLength / thetaDivision;
        if (this.radius < r + diagonalLength) {
            this.radius = r + diagonalLength;
        }
        int i = 0;
        while (i < this.size()) {
            this.graph.moveVertex(this.get(i), new Point2D.Double(this.radius, startTheta + thetaDivision * (double)i));
            ++i;
        }
    }
}

