/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import automata.Automaton;
import automata.graph.AutomatonDirectedGraph;
import automata.graph.AutomatonGraph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.CircleLayoutAlgorithm;
import automata.graph.layout.GEMLayoutAlgorithm;
import automata.graph.layout.RandomLayoutAlgorithm;
import automata.graph.layout.SpiralLayoutAlgorithm;
import automata.graph.layout.TreeLayoutAlgorithm;
import automata.graph.layout.TwoCircleLayoutAlgorithm;
import automata.graph.layout.VertexMover;
import java.awt.Dimension;
import java.util.Random;

public class LayoutAlgorithmFactory {
    private static final int NUM_ALGORITHMS = 7;
    public static final int RANDOM_CHOICE = -1;
    public static final int CIRCLE = 0;
    public static final int GEM = 1;
    public static final int RANDOM = 2;
    public static final int SPIRAL = 3;
    public static final int TREE_HIERARCHY = 4;
    public static final int TREE_DEGREE = 5;
    public static final int TWO_CIRCLE = 6;

    public static LayoutAlgorithm getRandomLayoutAlgorithm() {
        Random random = new Random();
        return LayoutAlgorithmFactory.getLayoutAlgorithm(Math.abs(random.nextInt() % 7));
    }

    public static LayoutAlgorithm getRandomLayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer) {
        Random random = new Random();
        return LayoutAlgorithmFactory.getLayoutAlgorithm(Math.abs(random.nextInt() % 7), pSize, vDim, vBuffer);
    }

    public static LayoutAlgorithm getLayoutAlgorithm(int algorithm) {
        switch (algorithm) {
            case -1: {
                return LayoutAlgorithmFactory.getRandomLayoutAlgorithm();
            }
            case 0: {
                return new CircleLayoutAlgorithm();
            }
            case 1: {
                return new GEMLayoutAlgorithm();
            }
            case 2: {
                return new RandomLayoutAlgorithm();
            }
            case 3: {
                return new SpiralLayoutAlgorithm();
            }
            case 5: {
                return new TreeLayoutAlgorithm(false);
            }
            case 4: {
                return new TreeLayoutAlgorithm(true);
            }
            case 6: {
                return new TwoCircleLayoutAlgorithm();
            }
            case -13: {
                return new VertexMover(-13);
            }
            case -12: {
                return new VertexMover(-12);
            }
            case -14: {
                return new VertexMover(-14);
            }
            case -10: {
                return new VertexMover(-10);
            }
            case -11: {
                return new VertexMover(-11);
            }
            case -15: {
                return new VertexMover(-15);
            }
        }
        return null;
    }

    public static LayoutAlgorithm getLayoutAlgorithm(int algorithm, Dimension pSize, Dimension vDim, double vBuffer) {
        switch (algorithm) {
            case -1: {
                return LayoutAlgorithmFactory.getRandomLayoutAlgorithm(pSize, vDim, vBuffer);
            }
            case 0: {
                return new CircleLayoutAlgorithm(pSize, vDim, vBuffer);
            }
            case 1: {
                return new GEMLayoutAlgorithm(pSize, vDim, vBuffer);
            }
            case 2: {
                return new RandomLayoutAlgorithm(pSize, vDim, vBuffer);
            }
            case 3: {
                return new SpiralLayoutAlgorithm(pSize, vDim, vBuffer);
            }
            case 5: {
                return new TreeLayoutAlgorithm(pSize, vDim, vBuffer, false);
            }
            case 4: {
                return new TreeLayoutAlgorithm(pSize, vDim, vBuffer, true);
            }
            case 6: {
                return new TwoCircleLayoutAlgorithm(pSize, vDim, vBuffer);
            }
            case -13: {
                return new VertexMover(pSize, vDim, vBuffer, -13);
            }
            case -12: {
                return new VertexMover(pSize, vDim, vBuffer, -12);
            }
            case -14: {
                return new VertexMover(pSize, vDim, vBuffer, -14);
            }
            case -10: {
                return new VertexMover(pSize, vDim, vBuffer, -10);
            }
            case -11: {
                return new VertexMover(pSize, vDim, vBuffer, -11);
            }
            case -15: {
                return new VertexMover(pSize, vDim, vBuffer, -15);
            }
        }
        return null;
    }

    public static AutomatonGraph getAutomatonGraph(int algorithm, Automaton automaton) {
        if (algorithm == 4) {
            return new AutomatonDirectedGraph(automaton);
        }
        return new AutomatonGraph(automaton);
    }
}

