/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import automata.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Set;

public abstract class LayoutAlgorithm {
    protected Dimension size;
    protected Dimension vertexDim;
    protected double vertexBuffer;

    public LayoutAlgorithm() {
        this.size = new Dimension(900, 900);
        this.vertexDim = new Dimension(30, 30);
        this.vertexBuffer = 30.0;
    }

    public LayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer) {
        this.size = pSize;
        this.vertexDim = vDim;
        this.vertexBuffer = vBuffer;
    }

    public abstract void layout(Graph var1, Set<Object> var2);

    public static void shiftOntoScreen(Graph graph, Dimension size, Dimension buffer, boolean scaleOnlyOverflow) {
        if (size == null || size.getHeight() == 0.0 || size.getWidth() == 0.0) {
            return;
        }
        Object[] vertices = graph.vertices();
        double minX = 2.147483647E9;
        double minY = 2.147483647E9;
        double maxX = -2.147483648E9;
        double maxY = -2.147483648E9;
        int i = 0;
        while (i < vertices.length) {
            double currentX = graph.pointForVertex(vertices[i]).getX();
            double currentY = graph.pointForVertex(vertices[i]).getY();
            if (currentX < minX) {
                minX = currentX;
            }
            if (currentX > maxX) {
                maxX = currentX;
            }
            if (currentY < minY) {
                minY = currentY;
            }
            if (currentY > maxY) {
                maxY = currentY;
            }
            ++i;
        }
        i = 0;
        while (i < vertices.length) {
            graph.moveVertex(vertices[i], new Point2D.Double(graph.pointForVertex(vertices[i]).getX() - minX, graph.pointForVertex(vertices[i]).getY() - minY));
            ++i;
        }
        double widthRatio = (maxX - minX) / (size.getWidth() - 2.0 * buffer.getWidth());
        double heightRatio = (maxY - minY) / (size.getHeight() - 2.0 * buffer.getHeight());
        if (widthRatio > 1.0 || !scaleOnlyOverflow) {
            i = 0;
            while (i < vertices.length) {
                graph.moveVertex(vertices[i], new Point2D.Double(graph.pointForVertex(vertices[i]).getX() / widthRatio, graph.pointForVertex(vertices[i]).getY()));
                ++i;
            }
        }
        if (heightRatio > 1.0 || !scaleOnlyOverflow) {
            i = 0;
            while (i < vertices.length) {
                graph.moveVertex(vertices[i], new Point2D.Double(graph.pointForVertex(vertices[i]).getX(), graph.pointForVertex(vertices[i]).getY() / heightRatio));
                ++i;
            }
        }
        i = 0;
        while (i < vertices.length) {
            graph.moveVertex(vertices[i], new Point2D.Double(graph.pointForVertex(vertices[i]).getX() + buffer.getWidth(), graph.pointForVertex(vertices[i]).getY() + buffer.getHeight()));
            ++i;
        }
    }

    public static ArrayList<Object> getMovableVertices(Graph graph, Set<Object> notMoving) {
        Object[] vArray = graph.vertices();
        ArrayList<Object> vertices = new ArrayList<Object>();
        int i = 0;
        while (i < vArray.length) {
            if (notMoving == null || !notMoving.contains(vArray[i])) {
                vertices.add(vArray[i]);
            }
            ++i;
        }
        return vertices;
    }

    public static void cartesianToPolar(Graph graph, ArrayList<Object> vertices) {
        int i = 0;
        while (i < vertices.size()) {
            Point2D cartesian = graph.pointForVertex(vertices.get(i));
            double theta = cartesian.getY() != 0.0 ? Math.atan(cartesian.getY() / cartesian.getX()) : 1.5707963267948966;
            double r = Math.sqrt(Math.pow(cartesian.getX(), 2.0) + Math.pow(cartesian.getY(), 2.0));
            graph.moveVertex(vertices.get(i), new Point2D.Double(r, theta));
            ++i;
        }
    }

    public static void polarToCartesian(Graph graph, ArrayList<Object> vertices) {
        int i = 0;
        while (i < vertices.size()) {
            Point2D polar = graph.pointForVertex(vertices.get(i));
            Point2D.Double cartesian = new Point2D.Double(Math.cos(polar.getY()) * polar.getX(), Math.sin(polar.getY()) * polar.getX());
            graph.moveVertex(vertices.get(i), cartesian);
            ++i;
        }
    }
}

