/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.AlphabetRetriever;
import automata.Automaton;
import automata.AutomatonChecker;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.UnreachableStatesDetector;
import automata.fsa.FSAAlphabetRetriever;
import automata.fsa.FSALabelHandler;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.MinimizeTreeNode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;

public class Minimizer {
    protected HashMap<State, State[]> MAP;
    protected State TRAP_STATE;

    public void initializeMinimizer() {
        this.MAP = new HashMap();
        this.TRAP_STATE = null;
    }

    public String getString(State[] states) {
        if (states.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int k = 0;
        while (k < states.length - 1) {
            buffer.append(Integer.toString(states[k].getID()));
            buffer.append(",");
            ++k;
        }
        buffer.append(Integer.toString(states[states.length - 1].getID()));
        return buffer.toString();
    }

    public String getTerminalToSplit(State[] group, Automaton automaton, DefaultTreeModel tree) {
        FSAAlphabetRetriever far = new FSAAlphabetRetriever();
        String[] alphabet = ((AlphabetRetriever)far).getAlphabet(automaton);
        int k = 0;
        while (k < alphabet.length) {
            if (this.isSplittableOnTerminal(group, alphabet[k], automaton, tree)) {
                return alphabet[k];
            }
            ++k;
        }
        return null;
    }

    public boolean isSplittableOnTerminal(State[] group, String terminal, Automaton automaton, DefaultTreeModel tree) {
        return this.getGroupsFromGroupOnTerminal(group, terminal, automaton, tree).size() > 1;
    }

    public boolean isSplittable(State[] group, Automaton automaton, DefaultTreeModel tree) {
        if (group.length <= 1) {
            return false;
        }
        FSAAlphabetRetriever far = new FSAAlphabetRetriever();
        String[] alphabet = ((AlphabetRetriever)far).getAlphabet(automaton);
        int k = 0;
        while (k < alphabet.length) {
            if (this.isSplittableOnTerminal(group, alphabet[k], automaton, tree)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public State[] getDistinguishableGroup(Automaton automaton, DefaultTreeModel tree) {
        MinimizeTreeNode root = (MinimizeTreeNode)tree.getRoot();
        ArrayList<State[]> distinguishableGroups = this.getLeaves(tree, root);
        for (State[] group : distinguishableGroups) {
            if (!this.isSplittable(group, automaton, tree)) continue;
            return group;
        }
        return null;
    }

    public State[] getGroupForState(State state, DefaultTreeModel tree) {
        MinimizeTreeNode root = (MinimizeTreeNode)tree.getRoot();
        ArrayList<State[]> distinguishableGroups = this.getLeaves(tree, root);
        for (State[] group : distinguishableGroups) {
            int k = 0;
            while (k < group.length) {
                if (group[k] == state) {
                    return group;
                }
                ++k;
            }
        }
        return null;
    }

    public boolean stateGoesToGroupOnTerminal(State state, State[] group, String terminal, Automaton automaton) {
        int k = 0;
        while (k < group.length) {
            Transition[] transitions = automaton.getTransitionsFromStateToState(state, group[k]);
            int j = 0;
            while (j < transitions.length) {
                FSATransition trans = (FSATransition)transitions[j];
                String label = trans.getLabel();
                if (label.equals(terminal)) {
                    return true;
                }
                ++j;
            }
            ++k;
        }
        return false;
    }

    public ArrayList<State[]> getGroupsFromGroupOnTerminal(State[] group, String terminal, Automaton automaton, DefaultTreeModel tree) {
        ArrayList<State[]> list = new ArrayList<State[]>();
        int k = 0;
        while (k < group.length) {
            if (group[k].getAutomaton() != automaton) {
                System.err.println("BADNESS!  BADNESS!");
            }
            Transition[] transitions = automaton.getTransitionsFromState(group[k]);
            int j = 0;
            while (j < transitions.length) {
                State[] node;
                FSATransition trans = (FSATransition)transitions[j];
                if (trans.getLabel().equals(terminal) && !list.contains(node = this.getGroupForState(transitions[j].getToState(), tree))) {
                    list.add(node);
                }
                ++j;
            }
            ++k;
        }
        return list;
    }

    public MinimizeTreeNode getTreeNodeForObject(DefaultTreeModel tree, MinimizeTreeNode root, State[] group) {
        State[] rootNode = (State[])root.getUserObject();
        if (rootNode == group) {
            return root;
        }
        int k = 0;
        while (k < root.getChildCount()) {
            MinimizeTreeNode node = this.getTreeNodeForObject(tree, (MinimizeTreeNode)root.getChildAt(k), group);
            if (node != null) {
                return node;
            }
            ++k;
        }
        return null;
    }

    public ArrayList<State[]> splitOnTerminal(State[] group, String terminal, Automaton automaton, DefaultTreeModel tree) {
        ArrayList<State[]> newGroups = new ArrayList<State[]>();
        MinimizeTreeNode root = (MinimizeTreeNode)tree.getRoot();
        ArrayList<State[]> distinguishableGroups = this.getLeaves(tree, root);
        Iterator<State[]> it = distinguishableGroups.iterator();
        while (it.hasNext()) {
            ArrayList<State> statesInGroup = new ArrayList<State>();
            State[] temp = it.next();
            int i = 0;
            while (i < group.length) {
                if (this.stateGoesToGroupOnTerminal(group[i], temp, terminal, automaton)) {
                    statesInGroup.add(group[i]);
                }
                ++i;
            }
            if (statesInGroup.size() <= 0) continue;
            State[] groupstates = statesInGroup.toArray(new State[0]);
            newGroups.add(groupstates);
        }
        return newGroups;
    }

    public boolean isMinimized(Automaton automaton, DefaultTreeModel tree) {
        State[] states = this.getDistinguishableGroup(automaton, tree);
        return states == null;
    }

    public ArrayList<State[]> split(State[] group, Automaton automaton, DefaultTreeModel tree) {
        String terminal = this.getTerminalToSplit(group, automaton, tree);
        ArrayList<State[]> list = new ArrayList<State[]>();
        list.addAll(this.splitOnTerminal(group, terminal, automaton, tree));
        return list;
    }

    public boolean isTransitionOnTerminal(Transition[] transitions, String terminal) {
        int k = 0;
        while (k < transitions.length) {
            FSATransition transition = (FSATransition)transitions[k];
            if (transition.getLabel().equals(terminal)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean needsTrapState(Automaton automaton) {
        FSAAlphabetRetriever far = new FSAAlphabetRetriever();
        String[] alphabet = ((AlphabetRetriever)far).getAlphabet(automaton);
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            Transition[] transitions = automaton.getTransitionsFromState(states[k]);
            int j = 0;
            while (j < alphabet.length) {
                if (!this.isTransitionOnTerminal(transitions, alphabet[j])) {
                    return true;
                }
                ++j;
            }
            ++k;
        }
        return false;
    }

    public void addTrapState(Automaton automaton) {
        State trapState;
        if (!this.needsTrapState(automaton)) {
            return;
        }
        StatePlacer sp = new StatePlacer();
        Point point = sp.getPointForState(automaton);
        this.TRAP_STATE = trapState = automaton.createState(point);
        FSAAlphabetRetriever far = new FSAAlphabetRetriever();
        String[] alphabet = ((AlphabetRetriever)far).getAlphabet(automaton);
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            Transition[] transitions = automaton.getTransitionsFromState(states[k]);
            int j = 0;
            while (j < alphabet.length) {
                if (!this.isTransitionOnTerminal(transitions, alphabet[j])) {
                    FSATransition trans = new FSATransition(states[k], trapState, alphabet[j]);
                    automaton.addTransition(trans);
                }
                ++j;
            }
            ++k;
        }
    }

    public Automaton getMinimizeableAutomaton(Automaton a) {
        AutomatonChecker ac = new AutomatonChecker();
        if (ac.isNFA(a)) {
            return null;
        }
        UnreachableStatesDetector usd = new UnreachableStatesDetector(a);
        State[] unreachableStates = usd.getUnreachableStates();
        int k = 0;
        while (k < unreachableStates.length) {
            a.removeState(unreachableStates[k]);
            ++k;
        }
        FSALabelHandler.removeMultipleCharacterLabelsFromAutomaton(a);
        this.addTrapState(a);
        return a;
    }

    public void printNode(MinimizeTreeNode treeNode) {
        State[] node = (State[])treeNode.getUserObject();
        System.out.print(this.getString(node));
    }

    public void printTree(DefaultTreeModel tree, MinimizeTreeNode root) {
        this.printNode(root);
        int k = 0;
        while (k < root.getChildCount()) {
            MinimizeTreeNode child = (MinimizeTreeNode)root.getChildAt(k);
            this.printTree(tree, child);
            ++k;
        }
    }

    public DefaultTreeModel getInitializedTree(Automaton automaton) {
        State[] finalStates;
        State[] states = automaton.getStates();
        MinimizeTreeNode root = new MinimizeTreeNode(states);
        DefaultTreeModel tree = new DefaultTreeModel(root);
        ArrayList<State> list = new ArrayList<State>();
        int k = 0;
        while (k < states.length) {
            if (!automaton.isFinalState(states[k])) {
                list.add(states[k]);
            }
            ++k;
        }
        State[] nonFinalStates = list.toArray(new State[0]);
        int childIndex = 0;
        if (nonFinalStates.length > 0) {
            MinimizeTreeNode nfstates = new MinimizeTreeNode(nonFinalStates);
            tree.insertNodeInto(nfstates, root, childIndex);
            ++childIndex;
        }
        if ((finalStates = automaton.getFinalStates()).length > 0) {
            MinimizeTreeNode fstates = new MinimizeTreeNode(finalStates);
            tree.insertNodeInto(fstates, root, childIndex);
        }
        return tree;
    }

    public void addChildrenToParent(ArrayList<State[]> children, MinimizeTreeNode parent, DefaultTreeModel tree) {
        int index = 0;
        for (State[] childGroup : children) {
            MinimizeTreeNode child = new MinimizeTreeNode(childGroup);
            tree.insertNodeInto(child, parent, index);
            ++index;
        }
    }

    public DefaultTreeModel getDistinguishableGroupsTree(Automaton automaton) {
        DefaultTreeModel tree = this.getInitializedTree(automaton);
        MinimizeTreeNode root = (MinimizeTreeNode)tree.getRoot();
        while (!this.isMinimized(automaton, tree)) {
            State[] group = this.getDistinguishableGroup(automaton, tree);
            ArrayList<State[]> children = new ArrayList<State[]>();
            String terminal = this.getTerminalToSplit(group, automaton, tree);
            children.addAll(this.splitOnTerminal(group, terminal, automaton, tree));
            MinimizeTreeNode parent = this.getTreeNodeForObject(tree, root, group);
            parent.setTerminal(terminal);
            this.addChildrenToParent(children, parent, tree);
        }
        return tree;
    }

    public boolean hasFinalState(State[] states, Automaton automaton) {
        int k = 0;
        while (k < states.length) {
            if (automaton.isFinalState(states[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean hasInitialState(State[] states, Automaton automaton) {
        State initialState = automaton.getInitialState();
        int k = 0;
        while (k < states.length) {
            if (states[k] == initialState) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public void mapStateToGroup(State state, State[] group) {
        this.MAP.put(state, group);
    }

    public State[] getGroupMappedToState(State state) {
        return this.MAP.get(state);
    }

    public void createStatesForMinimumDfa(Automaton dfa, Automaton minDfa, DefaultTreeModel tree) {
        MinimizeTreeNode root = (MinimizeTreeNode)tree.getRoot();
        ArrayList<State[]> groups = this.getLeaves(tree, root);
        StatePlacer sp = new StatePlacer();
        for (State[] group : groups) {
            if (this.containsTrapState(group)) continue;
            Point point = sp.getPointForState(minDfa);
            State state = minDfa.createState(point);
            state.setLabel(this.getString(group));
            if (this.hasInitialState(group, dfa)) {
                minDfa.setInitialState(state);
            }
            if (this.hasFinalState(group, dfa)) {
                minDfa.addFinalState(state);
            }
            this.mapStateToGroup(state, group);
        }
    }

    public State getStateMappedToGroup(State[] group, Automaton minDfa) {
        State[] states = minDfa.getStates();
        int k = 0;
        while (k < states.length) {
            State[] tempGroup = this.getGroupMappedToState(states[k]);
            if (tempGroup == group) {
                return states[k];
            }
            ++k;
        }
        return null;
    }

    public ArrayList<Transition> getTransitionsForState(State state, Automaton minDfa, Automaton dfa, DefaultTreeModel tree) {
        ArrayList<Transition> list = new ArrayList<Transition>();
        State[] group = this.getGroupMappedToState(state);
        State stateInGroup = group[0];
        Transition[] transitions = dfa.getTransitionsFromState(stateInGroup);
        int k = 0;
        while (k < transitions.length) {
            FSATransition trans = (FSATransition)transitions[k];
            State toState = trans.getToState();
            State[] toGroup = this.getGroupForState(toState, tree);
            if (!this.containsTrapState(toGroup)) {
                State to = this.getStateMappedToGroup(toGroup, minDfa);
                FSATransition transition = new FSATransition(state, to, trans.getLabel());
                list.add(transition);
            }
            ++k;
        }
        return list;
    }

    public ArrayList<State[]> getLeaves(DefaultTreeModel tree, MinimizeTreeNode root) {
        ArrayList<State[]> list = new ArrayList<State[]>();
        if (tree.isLeaf(root)) {
            State[] group = (State[])root.getUserObject();
            list.add(group);
        }
        int k = 0;
        while (k < root.getChildCount()) {
            MinimizeTreeNode child = (MinimizeTreeNode)root.getChildAt(k);
            list.addAll(this.getLeaves(tree, child));
            ++k;
        }
        return list;
    }

    public boolean containsTrapState(State[] states) {
        int k = 0;
        while (k < states.length) {
            if (states[k] == this.TRAP_STATE) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public FiniteStateAutomaton getMinimumDfa(Automaton automaton, DefaultTreeModel tree) {
        FiniteStateAutomaton minDfa = new FiniteStateAutomaton();
        this.createStatesForMinimumDfa(automaton, minDfa, tree);
        ArrayList<Transition> list = new ArrayList<Transition>();
        State[] states = minDfa.getStates();
        int k = 0;
        while (k < states.length) {
            list.addAll(this.getTransitionsForState(states[k], minDfa, automaton, tree));
            ++k;
        }
        for (Transition transition : list) {
            minDfa.addTransition(transition);
        }
        return minDfa;
    }
}

