/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.State;
import automata.Transition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UselessStatesDetector {
    private UselessStatesDetector() {
    }

    public static Automaton cleanAutomaton(Automaton a) {
        Automaton ac = (Automaton)a.clone();
        State[] s = ac.getStates();
        Set<State> useless = UselessStatesDetector.getUselessStates(ac);
        int i = 0;
        while (i < s.length) {
            if (useless.contains(s[i]) && s[i] != ac.getInitialState()) {
                ac.removeState(s[i]);
            }
            ++i;
        }
        if (useless.contains(ac.getInitialState())) {
            Transition[] t = ac.getTransitions();
            int i2 = 0;
            while (i2 < t.length) {
                ac.removeTransition(t[i2]);
                ++i2;
            }
        }
        return ac;
    }

    public static Set<State> getUselessStates(Automaton a) {
        if (a.getInitialState() == null) {
            throw new IllegalArgumentException("Automata does not have an initial state!");
        }
        Set<State> finalized = UselessStatesDetector.findFinal(a);
        Set<State> initialized = UselessStatesDetector.findInitial(a);
        HashSet<State> useless = new HashSet<State>(Arrays.asList(a.getStates()));
        finalized.retainAll(initialized);
        useless.removeAll(finalized);
        return useless;
    }

    private static Set<State> findFinal(Automaton a) {
        HashSet<State> finalized = new HashSet<State>();
        finalized.addAll(Arrays.asList(a.getFinalStates()));
        boolean added = finalized.size() != 0;
        Transition[] t = a.getTransitions();
        while (added) {
            added = false;
            int i = 0;
            while (i < t.length) {
                if (finalized.contains(t[i].getToState())) {
                    added = added || finalized.add(t[i].getFromState());
                }
                ++i;
            }
        }
        return finalized;
    }

    private static Set<State> findInitial(Automaton a) {
        HashSet<State> initialized = new HashSet<State>();
        initialized.add(a.getInitialState());
        boolean added = true;
        Transition[] t = a.getTransitions();
        while (added) {
            added = false;
            int i = 0;
            while (i < t.length) {
                if (initialized.contains(t[i].getFromState())) {
                    added = added || initialized.add(t[i].getToState());
                }
                ++i;
            }
        }
        return initialized;
    }
}

