/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.LambdaCheckerFactory;
import automata.LambdaTransitionChecker;
import automata.State;
import automata.Transition;
import java.util.ArrayList;

public abstract class NondeterminismDetector {
    public abstract boolean areNondeterministic(Transition var1, Transition var2);

    public State[] getNondeterministicStates(Automaton automaton) {
        LambdaTransitionChecker lc = LambdaCheckerFactory.getLambdaChecker(automaton);
        ArrayList<State> list = new ArrayList<State>();
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            State state = states[k];
            Transition[] transitions = automaton.getTransitionsFromState(state);
            int i = 0;
            while (i < transitions.length) {
                Transition t1 = transitions[i];
                if (lc.isLambdaTransition(t1)) {
                    if (!list.contains(state)) {
                        list.add(state);
                    }
                } else {
                    int p = i + 1;
                    while (p < transitions.length) {
                        Transition t2 = transitions[p];
                        if (this.areNondeterministic(t1, t2) && !list.contains(state)) {
                            list.add(state);
                        }
                        ++p;
                    }
                }
                ++i;
            }
            ++k;
        }
        return list.toArray(new State[0]);
    }
}

