#lang racket

; This reference implementation of the Euclid program available
; in our klein-programs folder enables us to see how many times
; each function is called in the course of a computation.

(define r 0)
(define g 0)

(define remainder
  (lambda (a b)
    (set! r (add1 r))
    (if (< a b)
        a
        (remainder (- a b) b))))

(define gcd
  (lambda (a b)
    (set! g (add1 g))
    (if (zero? b)
        a
        (gcd b (remainder a b)))))

(define run-test
  (lambda (a b)
    (set! r 0)
    (set! g 0)
    (gcd a b)
    (string-append "remainder: " (~a r) " gcd: " (~a g))))