public class JavaStringTest
{
    public static void main( String[] args )
    {
        String str = "This is a string";
        String longStr = "";
        for (int i = 0; i < 1000; i++)
            longStr += str;

        long shortOriginal = test( str );
        long longOriginal  = test( longStr );

        long shortOptimized = testOptimized( str );
        long longOptimized  = testOptimized( longStr );

        printTable(shortOriginal , longOriginal,
                   shortOptimized, longOptimized);
    }

    public static long test( String str )
    {
        long startTime = System.nanoTime();

	for (int i = 0; i < str.length(); i++) {
	    process(str.charAt(i));
	}

        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        return duration;
    }

    public static long testOptimized( String str )
    {
        long startTime = System.nanoTime();

	int len = str.length();
	for (int i = 0; i < len; i++) {
	    process(str.charAt(i));
	}

        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        return duration;
    }

    public static void process( char c ) { c = (char) (((int) c) + 1); }

    public static void printTable( long shortOriginal,  long longOriginal,
                                   long shortOptimized, long longOptimized )
    {
        System.out.println( "        original     optimized" );
        System.out.println( "short " + padLeft( shortOriginal,  10 ) +
                            "    "   + padLeft( shortOptimized, 10 ) );
        System.out.println( "long  " + padLeft( longOriginal,  10 ) +
                            "    "   + padLeft( longOptimized, 10 ) );
    }

    // http://stackoverflow.com/questions/388461/how-can-i-pad-a-string-in-java
    public static String padLeft( long s, int n )
    {
	return String.format("%1$" + n + "s", Long.toString(s));  
    }
}