import _tokens as t

# ---------------------------------------------------------------
# This program represents a 3AC statement using a quadruple:
#     [operator, arg1, arg2, result]

def arg1(quadruple):
    return quadruple[1]

def arg2(quadruple):
    return quadruple[2]

# ... and represents a 3AC program as a list of quadruples:
#     [stmt1, stmt2, ...]

program = [ [t.NEGATE, 'c',  t.EMPTY, 't1'],    # t1 =    -  c
            [t.TIMES,  'b',  't1',    't2'],    # t2 =  b * t1
            [t.NEGATE, 'c',  t.EMPTY, 't3'],    # t3 =    -  c
            [t.TIMES,  'b',  't3',    't4'],    # t4 =  b * t3
            [t.PLUS,   't2', 't4',    't5'],    # t5 = t2 + t4
            [t.COPY,   't5', t.EMPTY, 'a' ] ]   #  a = t5

# -----------------------------------------------------------------
# nextUse returns the next statement in program *after currentLine*
# that uses identifier

def nextUse(identifier, program, currentLine):
    for i in range(currentLine+1, len(program)):
        if arg1(program[i]) == identifier or \
           arg2(program[i]) == identifier:
            return i
    return -1

# nextUse test cases

assert  2 == nextUse('c', program, 0)
assert -1 == nextUse('c', program, 2)

assert  1 == nextUse('t1', program, 0)
assert -1 == nextUse('t1', program, 1)

assert -1 == nextUse('foo', program, -1)

# -----------------------------------------------------------------
# nextUses returns a list of *all* the statements in program that
# use identifier

def nextUses(identifier, program):
    result = []
    for i in range(0, len(program)):
        if arg1(program[i]) == identifier or \
           arg2(program[i]) == identifier:
             result.append(i)
    return result

# nextUses test cases

assert nextUses('foo', program) == []
assert nextUses('t1',  program) == [1]
assert nextUses('b',   program) == [1, 3]
assert nextUses('c',   program) == [0, 2]
assert nextUses('t4',  program) == [4]
assert nextUses('a',   program) == []

# -----------------------------------------------------------------
