public class CodeGen03
{
    public static void main(String[] args)
    {
        int value = Integer.parseInt(args[0]);
        String opcode = commandToOpCode(args[1]);
        generateCode(value, opcode);
    }

    public static void generateCode(int value, String opcode)
    {
        System.out.println(" 0:    LDC  0," + value + "(0)");
        System.out.println(" 1:    " + opcode + "  1,0,0");
        System.out.println(" 2:    OUT  1,0,0 ");
        System.out.println(" 3:   HALT  0,0,0 ");
    }

    public static String commandToOpCode(String c)
    {
        switch (c)
        {
            case "+" : return "ADD";
            case "-" : return "SUB";
            case "*" : return "MUL";
            case "/" : return "DIV";
        }
        return "HALT";
    }
}
